/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.filechooser;

import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDefaultFileSystemAdaptor;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxModel;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxNode;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sun.awt.shell.ShellFolder;

public class OyoahaDefaultFileSystemAdaptor2
extends OyoahaDefaultFileSystemAdaptor {
    protected static boolean initialized;
    protected static boolean useShellFolder;
    protected static boolean windowPlatform;

    public OyoahaDefaultFileSystemAdaptor2() {
        if (!initialized) {
            useShellFolder = false;
            try {
                Class<?> clazz = Class.forName("sun.awt.shell.ShellFolderManager");
                if (clazz != null) {
                    Method[] methodArray = clazz.getMethods();
                    int n = 0;
                    while (n < methodArray.length) {
                        if (methodArray[n].getName() == "get") {
                            useShellFolder = true;
                            break;
                        }
                        ++n;
                    }
                }
                windowPlatform = System.getProperty("os.name").startsWith("windows");
            }
            catch (Exception exception) {
                // empty catch block
            }
            initialized = true;
        }
    }

    public void getFileSystem(OyoahaDirectoryComboBoxModel oyoahaDirectoryComboBoxModel) {
        if (!useShellFolder) {
            super.getFileSystem(oyoahaDirectoryComboBoxModel);
        } else {
            try {
                File[] fileArray = (File[])ShellFolder.get("fileChooserComboBoxFolders");
                int[] nArray = this.calculateDepths(fileArray);
                if (OyoahaDefaultFileSystemAdaptor.extraFile != null) {
                    OyoahaDefaultFileSystemAdaptor.extraFile.clear();
                    OyoahaDefaultFileSystemAdaptor.extraFile = null;
                }
                OyoahaDefaultFileSystemAdaptor.extraFile = new Hashtable();
                int n = 0;
                while (n < fileArray.length) {
                    OyoahaDefaultFileSystemAdaptor.extraFile.put(fileArray[n], "folder");
                    ++n;
                }
                int n2 = 0;
                while (n2 < fileArray.length) {
                    oyoahaDirectoryComboBoxModel.add(new OyoahaDirectoryComboBoxNode(fileArray[n2], nArray[n2]));
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected int[] calculateDepths(File[] fileArray) {
        int[] nArray = new int[fileArray.length];
        int n = 0;
        while (n < nArray.length) {
            File file = fileArray[n];
            File file2 = file.getParentFile();
            nArray[n] = 0;
            if (file2 != null) {
                int n2 = n - 1;
                while (n2 >= 0) {
                    if (file2.equals(fileArray[n2])) {
                        nArray[n] = nArray[n2] + 1;
                        break;
                    }
                    --n2;
                }
            }
            ++n;
        }
        return nArray;
    }

    public boolean useGenericIcon(File file) {
        if (windowPlatform && !file.isDirectory() && file.getName() != null && file.getName().endsWith(".exe")) {
            return false;
        }
        return super.useGenericIcon(file);
    }

    public String getName(File file) {
        if (useShellFolder && file instanceof ShellFolder) {
            return ((ShellFolder)file).getDisplayName();
        }
        return super.getName(file);
    }

    public Icon getIcon(File file) {
        if (!useShellFolder) {
            return super.getIcon(file);
        }
        if (file instanceof ShellFolder) {
            Image image = ((ShellFolder)file).getIcon(false);
            if (image != null) {
                return new ImageIcon(image);
            }
        } else {
            try {
                ShellFolder shellFolder = ShellFolder.getShellFolder(file);
                Image image = shellFolder.getIcon(false);
                if (image != null) {
                    return new ImageIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getIcon(file);
    }

    public File resolve(File file) {
        if (!useShellFolder) {
            return file;
        }
        if (file instanceof ShellFolder) {
            try {
                if (((ShellFolder)file).isLink()) {
                    return ((ShellFolder)file).getLinkLocation();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.resolve(file);
    }

    public static Hashtable getExtraFile() {
        if (OyoahaDefaultFileSystemAdaptor.extraFile == null) {
            OyoahaDefaultFileSystemAdaptor.extraFile = new Hashtable();
        }
        return OyoahaDefaultFileSystemAdaptor.extraFile;
    }
}

