/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.filechooser;

import com.oyoaha.swing.plaf.oyoaha.OyoahaProperties;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDefaultFileSystemAdaptor;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDefaultFileSystemAdaptor2;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryComboBoxModel;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaDirectoryModel;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaFileSystemAdaptor;
import com.oyoaha.swing.plaf.oyoaha.filechooser.OyoahaVectorFolder;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;

public class OyoahaFileView
extends FileView {
    public static final String HARDDRIVE_TYPE = "hd";
    public static final String FLOPPY_TYPE = "floppy";
    public static final String FOLDER_TYPE = "folder";
    public static final String FILE_TYPE = "file";
    public static final String MY_DOCUMENT_TYPE = "doc";
    public static final String MY_COMPUTER_TYPE = "computer";
    public static final String MY_HOMEPAGE_TYPE = "web";
    public static final String MY_APPLICATION_TYPE = "app";
    public static final String DESKTOP_TYPE = "desktop";
    public static final String CURRENT_TYPE = "current";
    public static final String HOME_TYPE = "home";
    protected Hashtable iconCache;
    protected Hashtable preference;
    protected boolean changed;
    protected JFileChooser filechooser;
    protected OyoahaFileSystemAdaptor adaptor;

    public OyoahaFileView(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.iconCache = new Hashtable();
        this.preference = new OyoahaProperties();
        String string = System.getProperty("os.name");
        string = string.toLowerCase();
        File file = new File(System.getProperty("user.home"), ".filechooser" + File.separator + "OyoahaFileChooser.ini");
        if (file.exists()) {
            try {
                ((OyoahaProperties)this.preference).load(new FileInputStream(file), false);
            }
            catch (Exception exception) {}
        } else if (string.startsWith("windows")) {
            this.preference.put("organize", OyoahaDirectoryModel.getMode(0));
            this.preference.put("sort", OyoahaDirectoryModel.getSort(0));
        } else if (string.startsWith("macos")) {
            this.preference.put("organize", OyoahaDirectoryModel.getMode(1));
            this.preference.put("sort", OyoahaDirectoryModel.getSort(0));
        } else if (string.equals("sunos") || string.equals("solaris")) {
            this.preference.put("organize", OyoahaDirectoryModel.getMode(3));
            this.preference.put("sort", OyoahaDirectoryModel.getSort(1));
        } else {
            this.preference.put("organize", OyoahaDirectoryModel.getMode(3));
            this.preference.put("sort", OyoahaDirectoryModel.getSort(1));
        }
        this.adaptor = OyoahaUtilities.isVersion("1.4") ? new OyoahaDefaultFileSystemAdaptor2() : new OyoahaDefaultFileSystemAdaptor();
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public void dispose() {
        this.saveFileChooserPreference();
        this.clearIconCache();
    }

    public void clearIconCache() {
        this.iconCache.clear();
    }

    public Object getFileChooserPreference(Object object) {
        return this.preference.get(object);
    }

    public Object putFileChooserPreference(Object object, Object object2) {
        this.changed = true;
        return this.preference.put(object, object2);
    }

    private void saveFileChooserPreference() {
        if (this.changed) {
            File file;
            File file2 = new File(System.getProperty("user.home"), ".filechooser" + File.separator + "OyoahaFileChooser.ini");
            String string = file2.getParent();
            if (string != null && !(file = new File(string)).exists()) {
                file.mkdirs();
            }
            try {
                ((OyoahaProperties)this.preference).save(new FileOutputStream(file2), "created by OYOAHALOOKANDFEEL", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.changed = false;
        }
    }

    public OyoahaVectorFolder getRecentFolder() {
        return OyoahaVectorFolder.getVirtualFolder("recent");
    }

    public void addRecentFile(File file) {
        OyoahaVectorFolder oyoahaVectorFolder = OyoahaVectorFolder.getVirtualFolder("recent");
        oyoahaVectorFolder.addFile(file, 30);
        oyoahaVectorFolder.dispose();
    }

    public void removeRecentFile(File file) {
        OyoahaVectorFolder oyoahaVectorFolder = OyoahaVectorFolder.getVirtualFolder("recent");
        oyoahaVectorFolder.removeFile(file);
        oyoahaVectorFolder.dispose();
    }

    public void clearRecent() {
        OyoahaVectorFolder.deleteVectorFolder("recent");
    }

    public OyoahaVectorFolder getFavoriteFolder() {
        return OyoahaVectorFolder.getVirtualFolder("favorite");
    }

    public void addFavoriteFile(File file) {
        OyoahaVectorFolder oyoahaVectorFolder = OyoahaVectorFolder.getVirtualFolder("favorite");
        oyoahaVectorFolder.addFile(file);
        oyoahaVectorFolder.dispose();
    }

    public void removeFavoriteFile(File file) {
        OyoahaVectorFolder oyoahaVectorFolder = OyoahaVectorFolder.getVirtualFolder("favorite");
        oyoahaVectorFolder.removeFile(file);
        oyoahaVectorFolder.dispose();
    }

    public void clearFavorite() {
        OyoahaVectorFolder.deleteVectorFolder("favorite");
    }

    public File resolveFile(File file) {
        return this.adaptor.resolve(file);
    }

    public File[] getChild(File file) {
        if (file instanceof OyoahaVectorFolder) {
            ((OyoahaVectorFolder)file).listFiles();
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            File[] fileArray = new File[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                fileArray[n] = this.resolveFile(new File(file, stringArray[n]));
                ++n;
            }
            return fileArray;
        }
        return null;
    }

    public OyoahaDirectoryComboBoxModel getFileSystem() {
        return new OyoahaDirectoryComboBoxModel(this.getFileChooser());
    }

    public void getFileSystem(OyoahaDirectoryComboBoxModel oyoahaDirectoryComboBoxModel) {
        this.adaptor.getFileSystem(oyoahaDirectoryComboBoxModel);
    }

    public boolean deleteFile(File file) {
        return file.delete();
    }

    public boolean renameFile(File file, String string) {
        String string2 = file.getParent();
        if (string2 != null) {
            File file2 = new File(string2, string);
            return file.renameTo(file2);
        }
        return false;
    }

    public String getName(File file) {
        if (file instanceof OyoahaVectorFolder) {
            String string = file.getName();
            return string.substring(0, string.lastIndexOf("."));
        }
        return this.adaptor.getName(file);
    }

    public String getExtention(File file, boolean bl) {
        return this.adaptor.getExtention(file, bl);
    }

    public String getType(File file, boolean bl) {
        return this.adaptor.getType(file, bl);
    }

    public String getDescription(File file) {
        return this.adaptor.getDescription(file);
    }

    public String getTypeDescription(File file) {
        return this.adaptor.getTypeDescription(file);
    }

    public Icon getIcon(File file) {
        if (file instanceof OyoahaVectorFolder) {
            return this.adaptor.getIcon(file);
        }
        String string = this.adaptor.useGenericIcon(file) ? this.adaptor.getType(file, this.adaptor.isCaseSensitive()) + "-" + this.adaptor.getExtention(file, this.adaptor.isCaseSensitive()) : file.getPath();
        if (this.iconCache.containsKey(string)) {
            return (Icon)this.iconCache.get(string);
        }
        Icon icon = this.adaptor.getIcon(file);
        this.iconCache.put(string, icon);
        return icon;
    }

    public Color getColor(File file) {
        return this.adaptor.getColor(file);
    }

    public Boolean isTraversable(File file) {
        return this.adaptor.isTraversable(file);
    }

    public Boolean isHidden(File file) {
        return this.adaptor.isHidden(file);
    }
}

