/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.pool;

import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaStateRule;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeScheme;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeChanged;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeListener;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaColorPool;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaPoolUtilities;
import java.awt.Color;

public class OyoahaDefaultColorPool
implements OyoahaColorPool,
OyoahaThemeSchemeListener {
    protected Color u_enabled;
    protected Color s_enabled;
    protected Color u_rollover;
    protected Color s_rollover;
    protected Color u_disabled;
    protected Color s_disabled;
    protected Color u_pressed;
    protected Color s_pressed;
    protected Color unselected_enabled;
    protected Color selected_enabled;
    protected Color unselected_rollover;
    protected Color selected_rollover;
    protected Color unselected_disabled;
    protected Color selected_disabled;
    protected Color unselected_pressed;
    protected Color selected_pressed;
    protected OyoahaThemeScheme scheme;
    protected boolean useEnabledColorForSelected;
    protected boolean generateUnselectedPressed;
    protected boolean useSystemColor;

    public OyoahaDefaultColorPool(OyoahaLookAndFeel oyoahaLookAndFeel) {
        oyoahaLookAndFeel.addOyoahaThemeSchemeListener(this);
        this.scheme = oyoahaLookAndFeel.getOyoahaThemeScheme();
        this.useEnabledColorForSelected = false;
        this.useSystemColor = true;
    }

    public OyoahaDefaultColorPool(OyoahaLookAndFeel oyoahaLookAndFeel, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, Color color8, Boolean bl, Boolean bl2) {
        oyoahaLookAndFeel.addOyoahaThemeSchemeListener(this);
        this.scheme = oyoahaLookAndFeel.getOyoahaThemeScheme();
        this.u_enabled = color;
        this.s_enabled = color2;
        this.u_rollover = color3;
        this.s_rollover = color4;
        this.u_disabled = color5;
        this.s_disabled = color6;
        this.u_pressed = color7;
        this.s_pressed = color8;
        this.useEnabledColorForSelected = bl;
        this.generateUnselectedPressed = bl2;
        this.useSystemColor = false;
        this.init();
    }

    protected void init() {
        if (this.useSystemColor) {
            return;
        }
        this.unselected_enabled = this.scheme.isCustomEnabledColor() ? OyoahaPoolUtilities.getColor2(this.u_enabled, this.scheme.getEnabled()) : this.u_enabled;
        this.selected_enabled = this.useEnabledColorForSelected ? (this.scheme.isCustomEnabledColor() ? OyoahaPoolUtilities.getColor(this.s_enabled, this.scheme.getEnabled(), 100) : this.s_enabled) : OyoahaPoolUtilities.getColor(this.s_enabled, this.scheme.getSelected(), 50);
        Color color = (Color)OyoahaStateRule.getObject(1002, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled);
        this.unselected_rollover = color != null ? OyoahaPoolUtilities.getColor(color, this.scheme.getRollover(), 100) : this.scheme.getRollover();
        color = (Color)OyoahaStateRule.getObject(1006, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled);
        this.selected_rollover = color != null ? OyoahaPoolUtilities.getColor(color, this.scheme.getRollover(), 100) : this.scheme.getRollover();
        color = (Color)OyoahaStateRule.getObject(1003, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled);
        this.unselected_disabled = color != null ? OyoahaPoolUtilities.getColor3(color, this.scheme.getEnabled()) : this.scheme.getDisabled();
        color = (Color)OyoahaStateRule.getObject(1007, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled);
        this.selected_disabled = color != null ? OyoahaPoolUtilities.getColor3(color, this.scheme.getSelected()) : this.scheme.getDisabled();
        this.unselected_pressed = this.generateUnselectedPressed ? ((color = (Color)OyoahaStateRule.getObject(1001, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled)) != null ? OyoahaPoolUtilities.getColor(color, this.scheme.getPressed(), 100) : this.scheme.getPressed()) : null;
        color = (Color)OyoahaStateRule.getObject(1005, this.u_enabled, this.s_enabled, this.u_pressed, this.s_pressed, this.u_rollover, this.s_rollover, this.u_disabled, this.s_disabled);
        this.selected_pressed = color != null ? OyoahaPoolUtilities.getColor2(color, this.scheme.getPressed()) : this.scheme.getPressed();
    }

    public void updateThemeScheme(OyoahaThemeScheme oyoahaThemeScheme, OyoahaThemeSchemeChanged oyoahaThemeSchemeChanged) {
        this.scheme = oyoahaThemeScheme;
        this.init();
    }

    public void dispose() {
        this.unselected_enabled = null;
        this.selected_enabled = null;
        this.unselected_rollover = null;
        this.selected_rollover = null;
        this.unselected_disabled = null;
        this.selected_disabled = null;
        this.unselected_pressed = null;
        this.selected_pressed = null;
    }

    public Color getColor(int n) {
        if (this.useSystemColor) {
            return (Color)OyoahaStateRule.getObject(n, this.scheme.getEnabled(), this.scheme.getSelected(), this.scheme.getPressed(), this.scheme.getPressed(), this.scheme.getRollover(), this.scheme.getRollover(), this.scheme.getDisabled(), null);
        }
        return (Color)OyoahaStateRule.getObject(n, this.unselected_enabled, this.selected_enabled, this.unselected_pressed, this.selected_pressed, this.unselected_rollover, this.selected_rollover, this.unselected_disabled, null);
    }

    public Color getColor(Color color, int n) {
        if (this.useSystemColor && (n == 1000 ? !this.scheme.isCustomEnabledColor() : n == 1004 && this.useEnabledColorForSelected && !this.scheme.isCustomEnabledColor())) {
            return color;
        }
        return OyoahaDefaultColorPool.getColor(color, n, this.scheme, this.useEnabledColorForSelected);
    }

    public static final Color getColor(Color color, int n, OyoahaThemeScheme oyoahaThemeScheme, boolean bl) {
        switch (n) {
            case 1003: 
            case 1007: {
                return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getDisabled());
            }
            case 1001: 
            case 1005: {
                return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getPressed());
            }
            case 1002: 
            case 1006: {
                return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getRollover());
            }
            case 1004: {
                if (bl) {
                    if (oyoahaThemeScheme.isCustomEnabledColor()) {
                        return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getEnabled());
                    }
                    return color;
                }
                return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getSelected());
            }
            case 1000: {
                if (!oyoahaThemeScheme.isCustomEnabledColor()) break;
                return OyoahaPoolUtilities.getColor2(color, oyoahaThemeScheme.getEnabled());
            }
        }
        return color;
    }
}

