/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaColorPreviewPanel;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaSwatchChooserPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicColorChooserUI;

public class OyoahaColorChooserUI
extends BasicColorChooserUI {
    protected JColorChooser chooser;
    protected JPanel previewPanelHolder;
    protected JComponent previewPanel;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaColorChooserUI();
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void uninstallListeners() {
        if (this.chooser != null) {
            this.chooser.removePropertyChangeListener(this.propertyChangeListener);
            this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        }
    }

    protected void installPreviewPanel() {
        this.previewPanelHolder = new JPanel();
        this.previewPanelHolder.setLayout(new FlowLayout(1));
        String string = UIManager.getString("ColorChooser.previewText");
        this.previewPanelHolder.setBorder(new TitledBorder(string));
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new OyoahaColorPreviewPanel();
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.chooser.add((Component)this.previewPanelHolder, "South");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String string = UIManager.getString("ColorChooser.swatchesNameText");
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = super.createDefaultChoosers();
        int n = 0;
        while (n < abstractColorChooserPanelArray.length) {
            if (string.equalsIgnoreCase(abstractColorChooserPanelArray[n].getDisplayName())) {
                abstractColorChooserPanelArray[n] = new OyoahaSwatchChooserPanel();
            }
            ++n;
        }
        return abstractColorChooserPanelArray;
    }

    protected class PreviewListener
    implements ChangeListener {
        protected PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (OyoahaColorChooserUI.this.previewPanel != null) {
                OyoahaColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                OyoahaColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

