/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaBackgroundObject;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.icon.FileRendererIcon;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaFileChooserUI;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class OyoahaFileChooserJava2UI
extends OyoahaFileChooserUI {
    public OyoahaFileChooserJava2UI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaFileChooserJava2UI((JFileChooser)jComponent);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.model);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
        jFileChooser.removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.model);
        this.ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JButton jButton = OyoahaFileChooserJava2UI.this.getApproveButton(OyoahaFileChooserJava2UI.this.getFileChooser());
                if (jButton != null) {
                    jButton.requestFocus();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        jFileChooser.addAncestorListener(this.ancestorListener);
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected boolean getControlButtonsAreShown() {
        return this.getFileChooser().getControlButtonsAreShown();
    }

    protected InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("FileChooser.ancestorInputMap");
        }
        return null;
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OyoahaFileChooserJava2UI.this.editing) {
                    OyoahaFileChooserJava2UI.this.cancelEdit();
                    OyoahaFileChooserJava2UI.this.list.repaint();
                } else {
                    OyoahaFileChooserJava2UI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return OyoahaFileChooserJava2UI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("cancelSelection", abstractAction);
        return actionMapUIResource;
    }

    protected JComponent createList(JFileChooser jFileChooser) {
        this.list = new JList();
        this.list.setCellRenderer(new FileRendererJava2());
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getOyoahaModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(400, 220));
        if (OyoahaUtilities.isVersion("1.4")) {
            this.list.setLayoutOrientation(1);
        }
        return jScrollPane;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    OyoahaFileChooserJava2UI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    OyoahaFileChooserJava2UI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    OyoahaFileChooserJava2UI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    OyoahaFileChooserJava2UI.this.doControlButtonsChanged(propertyChangeEvent);
                }
            }
        };
    }

    protected class FileRendererJava2
    extends OyoahaListCellRenderer {
        protected FileRendererIcon fileRendererIcon;

        public FileRendererJava2() {
            this.drawsFocusBorderAroundIcon = false;
            this.fileRendererIcon = new FileRendererIcon();
            this.setIcon(this.fileRendererIcon);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color;
            Object object2;
            this.setComponentOrientation(jList.getComponentOrientation());
            this.list = jList;
            this.selected = bl;
            this.hasFocus = bl;
            this.isLeftToRight = OyoahaUtilities.isLeftToRight(jList);
            File file = (File)object;
            String string = OyoahaFileChooserJava2UI.this.getFileChooser().getName(file);
            if (OyoahaFileChooserJava2UI.this.sortedMode == 3) {
                object2 = DateFormat.getDateInstance();
                this.setText(((DateFormat)object2).format(new Date(file.lastModified())) + " - " + string.toLowerCase());
            } else if (OyoahaFileChooserJava2UI.this.sortedMode == 2) {
                if (file.isDirectory()) {
                    this.setText(string.toLowerCase());
                } else {
                    long l = file.length();
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    this.setText(numberFormat.format(l) + " - " + string.toLowerCase());
                }
            } else if (OyoahaFileChooserJava2UI.this.sortedMode == 1) {
                this.setText(string);
            } else {
                this.setText(string.toLowerCase());
            }
            object2 = OyoahaFileChooserJava2UI.this.getOyoahaFileView(OyoahaFileChooserJava2UI.this.getFileChooser()).getIcon(file);
            if (object2 == null) {
                object2 = OyoahaFileChooserJava2UI.this.getFileChooser().getIcon(file);
            }
            this.fileRendererIcon.icon = object2;
            this.setComponentOrientation(jList.getComponentOrientation());
            if (bl || bl2) {
                OyoahaFileChooserJava2UI.this.editX = this.getBorderStart();
                this.setForeground(jList.getSelectionForeground());
                this.fileRendererIcon.color = null;
            }
            this.fileRendererIcon.color = (color = OyoahaFileChooserJava2UI.this.getOyoahaFileView(OyoahaFileChooserJava2UI.this.getFileChooser()).getColor(file)) != null ? color : null;
            this.setForeground(jList.getForeground());
            this.setOpaque(false);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(UIManager.getBorder("List.selectionBorder"));
            return this;
        }

        public void paint(Graphics graphics) {
            int n;
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else {
                n = this.getLabelStart() - 1;
                if (n < 0) {
                    n = 0;
                }
            }
            Color color = this.selected ? this.list.getSelectionBackground() : this.list.getBackground();
            if (color == null) {
                color = this.getBackground();
            }
            graphics.setColor(color);
            if (this.selected) {
                OyoahaBackgroundObject oyoahaBackgroundObject = OyoahaUtilities.getBackgroundObject("Tree.Renderer");
                if (this.isLeftToRight) {
                    Shape shape = OyoahaUtilities.normalizeClip(graphics, n, 0, this.getWidth() - 1 - n, this.getHeight());
                    if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                        oyoahaBackgroundObject.paintBackground(graphics, this, n, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                    } else {
                        OyoahaUtilities.paintColorBackground(graphics, this, n, 0, this.getWidth() - 1 - n, this.getHeight(), color, 1004);
                    }
                    graphics.setClip(shape);
                } else {
                    Shape shape = OyoahaUtilities.normalizeClip(graphics, 0, 0, this.getWidth() - 1 - n, this.getHeight());
                    if (oyoahaBackgroundObject != null && color instanceof UIResource) {
                        oyoahaBackgroundObject.paintBackground(graphics, this, 0, 0, this.getWidth() - 1 - n, this.getHeight(), 1004);
                    } else {
                        OyoahaUtilities.paintColorBackground(graphics, this, 0, 0, this.getWidth() - 1 - n, this.getHeight(), color, 1004);
                    }
                    graphics.setClip(shape);
                }
            }
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            if (OyoahaUtilities.isVersion("1.4")) {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 200;
                dimension.height = 24;
                return dimension;
            }
            return super.getPreferredSize();
        }
    }
}

