/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaButtonLikeComponent;
import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class OyoahaRadioButtonUI
extends MetalRadioButtonUI
implements OyoahaButtonLikeComponent {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaRadioButtonUI();
    }

    public boolean isBorderPainted(Component component) {
        return ((AbstractButton)component).isBorderPainted();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OyoahaUtilities.installRolloverListener(jComponent);
        OyoahaUtilities.setOpaque(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OyoahaUtilities.uninstallRolloverListener(jComponent);
        OyoahaUtilities.unsetOpaque(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OyoahaUtilities.paintBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        Object var14_14 = null;
        Object var15_15 = null;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getDefaultTextIconGap(abstractButton));
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(UIManager.getColor("Label.disabledForeground"));
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            }
        }
        if (abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        boolean bl;
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl2 = bl = abstractButton.getIcon() != null;
        if (string != null && !string.equals("")) {
            if (!bl) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl) {
            rectangle4.setBounds(rectangle3);
        } else {
            rectangle4.setBounds(rectangle);
        }
        graphics.setColor(OyoahaUtilities.getColorFromScheme(100));
        int n = rectangle4.y + rectangle4.height - 1;
        graphics.drawLine(rectangle4.x, rectangle4.y, rectangle4.x + rectangle4.width - 1, rectangle4.y);
        graphics.drawLine(rectangle4.x, n, rectangle4.x + rectangle4.width - 1, n);
    }
}

