/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaScrollButton;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class OyoahaSpinnerUI
extends BasicSpinnerUI {
    protected static final OyoahaArrowButtonHandler nextButtonHandler = new OyoahaArrowButtonHandler(true);
    protected static final OyoahaArrowButtonHandler previousButtonHandler = new OyoahaArrowButtonHandler(false);

    public static ComponentUI createUI(JComponent jComponent) {
        return new OyoahaSpinnerUI();
    }

    protected Component createPreviousButton() {
        OyoahaScrollButton oyoahaScrollButton = new OyoahaScrollButton(5, (Integer)UIManager.get("ScrollBar.width"), false, true, true);
        oyoahaScrollButton.addActionListener(previousButtonHandler);
        oyoahaScrollButton.addMouseListener(previousButtonHandler);
        return oyoahaScrollButton;
    }

    protected Component createNextButton() {
        OyoahaScrollButton oyoahaScrollButton = new OyoahaScrollButton(1, (Integer)UIManager.get("ScrollBar.width"), false, true, true);
        oyoahaScrollButton.addActionListener(nextButtonHandler);
        oyoahaScrollButton.addMouseListener(nextButtonHandler);
        return oyoahaScrollButton;
    }

    protected static class OyoahaArrowButtonHandler
    extends MouseAdapter
    implements ActionListener {
        protected final Timer autoRepeatTimer;
        protected final boolean isNext;
        protected JSpinner spinner = null;

        public OyoahaArrowButtonHandler(boolean bl) {
            this.isNext = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        protected JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.spinner != null) {
                try {
                    Object object;
                    this.spinner.commitEdit();
                    Object object2 = object = this.isNext ? this.spinner.getNextValue() : this.spinner.getPreviousValue();
                    if (object != null) {
                        this.spinner.setValue(object);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.spinner);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }
    }
}

