/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaMainSwatchPanel;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaRecentSwatchPanel;
import com.oyoaha.swing.plaf.oyoaha.ui.OyoahaSwatchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class OyoahaSwatchChooserPanel
extends AbstractColorChooserPanel {
    protected OyoahaSwatchPanel swatchPanel;
    protected MouseListener mainSwatchListener;
    protected MouseListener recentSwatchListener;
    protected static OyoahaRecentSwatchPanel recentSwatchPanel;
    protected static String recentStr;

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    protected void buildChooser() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.swatchPanel = new OyoahaMainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        if (recentSwatchPanel == null) {
            recentSwatchPanel = new OyoahaRecentSwatchPanel();
            recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        }
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(OyoahaUtilities.getScheme().getGray()));
        this.swatchPanel.setBorder(compoundBorder);
        jPanel.add((Component)this.swatchPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(recentStr);
        jLabel.setLabelFor(recentSwatchPanel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        jPanel2.add((Component)jLabel, "North");
        recentSwatchPanel.setBorder(compoundBorder);
        jPanel2.add((Component)recentSwatchPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    public void updateChooser() {
    }

    static {
        recentStr = UIManager.getString("ColorChooser.swatchesRecentText");
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = OyoahaSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            OyoahaSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            OyoahaSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

