/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.ui;

import com.oyoaha.swing.plaf.oyoaha.OyoahaUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class OyoahaSwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public OyoahaSwatchPanel() {
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setRequestFocusEnabled(false);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void initValues() {
    }

    public void paintComponent(Graphics graphics) {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        Dimension dimension = this.getSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        graphics.setColor(OyoahaUtilities.getScheme().getGray());
        graphics.fillRect(n3, n4, n, n2);
        int n5 = 0;
        while (n5 < this.numSwatches.height) {
            int n6 = 0;
            while (n6 < this.numSwatches.width) {
                graphics.setColor(this.getColorForCell(n6, n5));
                int n7 = n6 * (this.swatchSize.width + this.gap.width);
                int n8 = n5 * (this.swatchSize.height + this.gap.height);
                graphics.fillRect(n3 + n7, n4 + n8, this.swatchSize.width, this.swatchSize.height);
                ++n6;
            }
            ++n5;
        }
    }

    public Dimension getPreferredSize() {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
        return new Dimension(n, n2);
    }

    protected void initColors() {
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int n, int n2) {
        int n3 = n / (this.swatchSize.width + this.gap.width);
        int n4 = n2 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n3, n4);
    }

    private Color getColorForCell(int n, int n2) {
        int n3 = n2 * this.numSwatches.width + n;
        if (n3 < this.colors.length) {
            return this.colors[n3];
        }
        return this.colors[0];
    }
}

