/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysql;
import gwe.sql.gweMysqlMetaResult;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public class gweMysqlResultSet
implements ResultSet {
    private gweMysql result;
    private gweMysqlMetaResult meta;
    private int last_read = -1;

    public gweMysqlResultSet(gweMysql gweMysql2) {
        this.result = gweMysql2;
    }

    public synchronized boolean next() throws SQLException {
        try {
            this.last_read = -1;
            return this.result.nextResult();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean isNull(int n) throws SQLException {
        try {
            return this.result.isNull(n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean wasNull() throws SQLException {
        if (this.last_read == -1) {
            return false;
        }
        return this.isNull(this.last_read);
    }

    public String getString(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return null;
        }
        try {
            return this.result.getString(n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public byte getByte(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return 0;
        }
        try {
            String string = this.result.getString(n);
            if (string.equals("")) {
                return 0;
            }
            return (byte)Integer.valueOf(string).intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.last_read = n;
        if (this.isNull(n)) {
            return false;
        }
        try {
            String string = this.result.getString(n);
            if (string.equals("")) {
                return false;
            }
            if (string.equals("0")) {
                return false;
            }
            if (string.equals("N")) {
                return false;
            }
            return !string.equals("n");
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0;
            }
            return (short)Integer.valueOf(string).intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0;
            }
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0L;
            }
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0.0f;
            }
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return 0.0;
            }
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            this.last_read = n;
            String string = this.result.getString(n);
            if (string == null) {
                return new BigDecimal(new BigInteger("0"), n2);
            }
            return new BigDecimal(new BigInteger(string), n2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            String string2 = this.result.getString(string);
            if (string2 == null) {
                return new BigDecimal(new BigInteger("0"), n);
            }
            return new BigDecimal(new BigInteger(string2), n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.result.getBytes(n);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            Integer n2 = new Integer(string.substring(0, 2));
            Integer n3 = new Integer(string.substring(2, 4));
            Integer n4 = new Integer(string.substring(4, 6));
            return new Date(n2, n3 - 1, n4);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            Integer n2 = new Integer(string.substring(6, 8));
            Integer n3 = new Integer(string.substring(8, 10));
            Integer n4 = new Integer(string.substring(10, 12));
            return new Time(n2, n3, n4);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            String string = this.result.getString(n);
            if (string == null) {
                return null;
            }
            Integer n2 = new Integer(string.substring(0, 2));
            Integer n3 = new Integer(string.substring(2, 4));
            Integer n4 = new Integer(string.substring(4, 6));
            Integer n5 = new Integer(string.substring(6, 8));
            Integer n6 = new Integer(string.substring(8, 10));
            Integer n7 = new Integer(string.substring(10, 12));
            return new Timestamp(n2, n3 - 1, n4, n5, n6, n7, 0);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return null;
    }

    public void close() throws SQLException {
        try {
            this.result.reConnect();
            return;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new gweMysqlMetaResult(this.result);
        }
        return this.meta;
    }

    public Object getObject(int n, int n2, int n3) throws SQLException {
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, n3);
            }
            case 3: {
                return this.getBigDecimal(n, n3);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return null;
    }

    public Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, 0);
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return this.getObject(n, n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n, 0);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public boolean isNull(String string) throws SQLException {
        return this.isNull(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            return this.result.getColumnNum(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }
}

