/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFormatter;

public class PlotFrame
extends JFrame {
    public PlotBox plot;
    protected JMenuBar _menubar = new JMenuBar();
    protected JMenu _editMenu = new JMenu("Edit");
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenu _specialMenu = new JMenu("Special");
    protected File _directory = null;
    protected File _file = null;

    public PlotFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotFrame(String title) {
        this(title, (PlotBox)null);
    }

    public PlotFrame(String title, PlotBox plotArg) {
        super(title);
        this.plot = plotArg == null ? new Plot() : plotArg;
        this.plot.setBackground(new Color(0xE5E5E5));
        this._fileMenu.setMnemonic(70);
        this._editMenu.setMnemonic(69);
        this._specialMenu.setMnemonic(83);
        JMenuItem[] fileMenuItems = new JMenuItem[]{new JMenuItem("Open", 79), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Export", 69), new JMenuItem("Print", 80), new JMenuItem("Close", 67)};
        fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenuItems[1].setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenuItems[4].setAccelerator(KeyStroke.getKeyStroke(80, 2));
        fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(87, 2));
        FileMenuListener fml = new FileMenuListener();
        int i = 0;
        while (i < fileMenuItems.length) {
            fileMenuItems[i].setActionCommand(fileMenuItems[i].getText());
            fileMenuItems[i].addActionListener(fml);
            this._fileMenu.add(fileMenuItems[i]);
            ++i;
        }
        this._menubar.add(this._fileMenu);
        JMenuItem format = new JMenuItem("Format", 70);
        FormatListener formatListener = new FormatListener();
        format.addActionListener(formatListener);
        this._editMenu.add(format);
        this._menubar.add(this._editMenu);
        JMenuItem[] specialMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72), new JMenuItem("Clear", 67), new JMenuItem("Fill", 70), new JMenuItem("Reset axes", 82), new JMenuItem("Sample plot", 83)};
        SpecialMenuListener sml = new SpecialMenuListener();
        int i2 = 0;
        while (i2 < specialMenuItems.length) {
            specialMenuItems[i2].setActionCommand(specialMenuItems[i2].getText());
            specialMenuItems[i2].addActionListener(sml);
            this._specialMenu.add(specialMenuItems[i2]);
            ++i2;
        }
        this._menubar.add(this._specialMenu);
        this.setJMenuBar(this._menubar);
        this.getContentPane().add((Component)this.plot, "Center");
        ((Component)this).setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        ((Component)this).setLocation(x, y);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotFrame class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.1p2, Build: $Id: PlotFrame.java,v 1.45 2001/03/08 20:56:24 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2001, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        this.dispose();
    }

    protected void _editFormat() {
        PlotFormatter fmt = new PlotFormatter(this.plot);
        fmt.openModal();
    }

    protected void _export() {
        block5: {
            JFileChooser fileDialog = new JFileChooser();
            fileDialog.setDialogTitle("Export EPS to...");
            if (this._directory != null) {
                fileDialog.setCurrentDirectory(this._directory);
            } else {
                String cwd = System.getProperty("user.dir");
                if (cwd != null) {
                    fileDialog.setCurrentDirectory(new File(cwd));
                }
            }
            int returnVal = fileDialog.showDialog(this, "Export");
            if (returnVal != 0) break block5;
            File file = fileDialog.getSelectedFile();
            try {
                FileOutputStream fout = new FileOutputStream(file);
                this.plot.export(fout);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error exporting plot: " + ex, "Ptolemy II Error", 2);
            }
        }
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotFrame is a plot in a top-level window.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.", "About Ptolemy Plot", 1);
    }

    protected void _open() {
        block6: {
            JFileChooser fileDialog = new JFileChooser();
            fileDialog.setDialogTitle("Select a plot file");
            if (this._directory != null) {
                fileDialog.setCurrentDirectory(this._directory);
            } else {
                String cwd = System.getProperty("user.dir");
                if (cwd != null) {
                    fileDialog.setCurrentDirectory(new File(cwd));
                }
            }
            int returnVal = fileDialog.showOpenDialog(this);
            if (returnVal != 0) break block6;
            this._file = fileDialog.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = fileDialog.getCurrentDirectory();
            try {
                this.plot.clear(true);
                this._read(new URL("file", null, this._directory.getAbsolutePath()), new FileInputStream(this._file));
                this.plot.repaint();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "File not found:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error reading input:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
        }
    }

    protected void _print() {
        block2: {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this.plot);
            if (!job.printDialog()) break block2;
            try {
                job.print();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + ex.toString(), "Print Error", 2);
            }
        }
    }

    protected void _read(URL base, InputStream in) throws IOException {
        this.plot.read(in);
    }

    protected void _save() {
        if (this._file != null) {
            try {
                FileOutputStream fout = new FileOutputStream(this._file);
                this.plot.write(fout);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error writing file:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle("Save plot as...");
        if (this._directory != null) {
            fileDialog.setCurrentDirectory(this._directory);
        } else {
            String cwd = System.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        int returnVal = fileDialog.showSaveDialog(this);
        if (returnVal == 0) {
            this._file = fileDialog.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = fileDialog.getCurrentDirectory();
            this._save();
        }
    }

    public void samplePlot() {
        this._file = null;
        this._directory = null;
        this.plot.samplePlot();
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("Open")) {
                PlotFrame.this._open();
            } else if (actionCommand.equals("Save")) {
                PlotFrame.this._save();
            } else if (actionCommand.equals("SaveAs")) {
                PlotFrame.this._saveAs();
            } else if (actionCommand.equals("Export")) {
                PlotFrame.this._export();
            } else if (actionCommand.equals("Print")) {
                PlotFrame.this._print();
            } else if (actionCommand.equals("Close")) {
                PlotFrame.this._close();
            }
            PlotFrame.this.repaint();
        }
    }

    class FormatListener
    implements ActionListener {
        FormatListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlotFrame.this._editFormat();
            PlotFrame.this.repaint();
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            if (actionCommand.equals("About")) {
                PlotFrame.this._about();
            } else if (actionCommand.equals("Help")) {
                PlotFrame.this._help();
            } else if (actionCommand.equals("Fill")) {
                PlotFrame.this.plot.fillPlot();
            } else if (actionCommand.equals("Reset axes")) {
                PlotFrame.this.plot.resetAxes();
            } else if (actionCommand.equals("Clear")) {
                PlotFrame.this.plot.clear(false);
                PlotFrame.this.plot.repaint();
            } else if (actionCommand.equals("Sample plot")) {
                PlotFrame.this.plot.clear(true);
                PlotFrame.this.samplePlot();
            }
            PlotFrame.this.repaint();
        }
    }
}

