/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.SSLServerSocketFactory;
import org.mortbay.http.JsseListener;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.Password;

public class SunJsseListener
extends JsseListener {
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private String _keystore_type = DEFAULT_KEYSTORE_TYPE;
    private String _keystore_provider_name = DEFAULT_KEYSTORE_PROVIDER_NAME;
    private String _keystore_provider_class = DEFAULT_KEYSTORE_PROVIDER_CLASS;
    private boolean _useDefaultTrustStore = false;

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword("jetty.ssl.password", password, null);
    }

    public void setKeyPassword(String password) {
        this._keypassword = Password.getPassword("jetty.ssl.keypassword", password, null);
    }

    public void setKeystoreType(String keystore_type) {
        this._keystore_type = keystore_type;
    }

    public String getKeystoreType() {
        return this._keystore_type;
    }

    public void setKeystoreProviderName(String name) {
        this._keystore_provider_name = name;
    }

    public String getKeystoreProviderName() {
        return this._keystore_provider_name;
    }

    public String getKeystoreProviderClass() {
        return this._keystore_provider_class;
    }

    public void setKeystoreProviderClass(String classname) {
        this._keystore_provider_class = classname;
    }

    public boolean getUseDefaultTrustStore() {
        return this._useDefaultTrustStore;
    }

    public void setUseDefaultTrustStore(boolean flag) {
        this._useDefaultTrustStore = flag;
    }

    public SunJsseListener() {
    }

    public SunJsseListener(InetAddrPort p_address) {
        super(p_address);
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        this._keystore = System.getProperty("jetty.ssl.keystore", this._keystore);
        Log.event("jetty.ssl.keystore=" + this._keystore);
        if (this._password == null) {
            this._password = Password.getPassword("jetty.ssl.password", null, null);
        }
        Log.event("jetty.ssl.password=" + this._password.toStarString());
        if (this._keypassword == null) {
            this._keypassword = Password.getPassword("jetty.ssl.keypassword", null, this._password.toString());
        }
        Log.event("jetty.ssl.keypassword=" + this._keypassword.toStarString());
        KeyStore ks = null;
        Log.event("jetty.ssl.keystore.type=" + this._keystore_type);
        if (this._keystore_provider_class != null) {
            java.security.Provider[] installed_providers = Security.getProviders();
            java.security.Provider myprovider = null;
            for (int i = 0; i < installed_providers.length; ++i) {
                if (!installed_providers[i].getClass().getName().equals(this._keystore_provider_class)) continue;
                myprovider = installed_providers[i];
                break;
            }
            if (myprovider == null) {
                myprovider = (java.security.Provider)Class.forName(this._keystore_provider_class).newInstance();
                Security.addProvider(myprovider);
            }
            Log.event("jetty.ssl.keystore.provider.class=" + this._keystore_provider_class);
            ks = KeyStore.getInstance(this._keystore_type, myprovider.getName());
        } else if (this._keystore_provider_name != null) {
            Log.event("jetty.ssl.keystore.provider.name=" + this._keystore_provider_name);
            ks = KeyStore.getInstance(this._keystore_type, this._keystore_provider_name);
        } else {
            ks = KeyStore.getInstance(this._keystore_type);
            Log.event("jetty.ssl.keystore.provider.name=[DEFAULT]");
        }
        ks.load(new FileInputStream(new File(this._keystore)), this._password.toString().toCharArray());
        KeyManagerFactory km = KeyManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
        km.init(ks, this._keypassword.toString().toCharArray());
        KeyManager[] kma = km.getKeyManagers();
        TrustManagerFactory tm = TrustManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
        if (this._useDefaultTrustStore) {
            tm.init((KeyStore)null);
        } else {
            tm.init(ks);
        }
        TrustManager[] tma = tm.getTrustManagers();
        SSLContext sslc = SSLContext.getInstance((String)"SSL");
        sslc.init(kma, tma, SecureRandom.getInstance("SHA1PRNG"));
        SSLServerSocketFactory ssfc = sslc.getServerSocketFactory();
        Log.event("SSLServerSocketFactory=" + ssfc);
        return ssfc;
    }

    static {
        Security.addProvider((java.security.Provider)new Provider());
    }
}

