// $Id$
// @author Cory Sharp <cssharp@eecs.berkeley.edu>

// CountDual:
//   If the mote id is 1, count to the leds and send it over the radio.
//   Otherwise, receive the count from the radio and display it on the leds.

includes CountMsg;

configuration CountDualAckC
{
}
implementation
{
  components Main
           , CountDualAckM
	   , TimerC
	   , GenericComm
	   , LedsC
           , CC2420RadioC
	   ;
  
  Main.StdControl -> GenericComm;
  Main.StdControl -> TimerC;
  Main.StdControl -> CountDualAckM;

  CountDualAckM.Timer -> TimerC.Timer[unique("Timer")];
  CountDualAckM.SendMsg -> GenericComm.SendMsg[AM_COUNT_MSG];
  CountDualAckM.ReceiveMsg -> GenericComm.ReceiveMsg[AM_COUNT_MSG];
  CountDualAckM.Leds -> LedsC.Leds;
  CountDualAckM.MacControl -> CC2420RadioC;
}

