// $Id$
// @author Cory Sharp <cssharp@eecs.berkeley.edu>

// CountDual:
//   If the mote id is 1, count to the leds and send it over the radio.
//   Otherwise, receive the count from the radio and display it on the leds.

includes CountMsg;

configuration CountDualC
{
}
implementation
{
  components Main
           , CountDualM
	   , TimerC
	   , GenericComm
	   , LedsC
	   ;
  
  Main.StdControl -> CountDualM;
  Main.StdControl -> GenericComm;
  Main.StdControl -> TimerC;

  CountDualM.Timer -> TimerC.Timer[unique("Timer")];
  CountDualM.SendMsg -> GenericComm.SendMsg[AM_COUNT_MSG];
  CountDualM.ReceiveMsg -> GenericComm.ReceiveMsg[AM_COUNT_MSG];
  CountDualM.Leds -> LedsC.Leds;
}

