// $Id$
// @author Cory Sharp <cssharp@eecs.berkeley.edu>

includes CountMsg;
includes Timer;

module CountDualM
{
  provides interface StdControl;
  uses interface Timer;
  uses interface SendMsg;
  uses interface ReceiveMsg;
  uses interface Leds;
}
implementation
{
  TOS_Msg m_msg;
  int m_int;
  bool m_sending;

  command result_t StdControl.init()
  {
    m_int = 0;
    m_sending = FALSE;
    call Leds.init();
    return SUCCESS;
  }

  command result_t StdControl.start()
  {
    if( TOS_LOCAL_ADDRESS == 1 )
      call Timer.start( TIMER_REPEAT, 200 );
    return SUCCESS;
  }

  command result_t StdControl.stop()
  {
    return SUCCESS;
  }

  event result_t Timer.fired()
  {
    if( m_sending == FALSE )
    {
      CountMsg_t* body = (CountMsg_t*)m_msg.data;
      body->n = m_int;
      body->src = TOS_LOCAL_ADDRESS;
      if( call SendMsg.send( TOS_BCAST_ADDR, sizeof(CountMsg_t), &m_msg ) == SUCCESS )
      {
	call Leds.set( m_int );
	m_sending = TRUE;
      }
    }
    m_int++;
    return SUCCESS;
  }

  event result_t SendMsg.sendDone( TOS_MsgPtr msg, result_t success )
  {
    m_sending = FALSE;
    return SUCCESS;
  }

  event TOS_MsgPtr ReceiveMsg.receive( TOS_MsgPtr msg )
  {
    if( TOS_LOCAL_ADDRESS != 1 )
    {
      CountMsg_t* body = (CountMsg_t*)(&msg->data[0]);
      call Leds.set( body->n );
    }
    return msg;
  }
}

