// $Id$
// @author Cory Sharp <cssharp@eecs.berkeley.edu>

includes CountMsg;

module CountReceiveM
{
  provides interface StdControl;
  uses interface ReceiveMsg;
  uses interface Leds;
}
implementation
{
  command result_t StdControl.init()
  {
    call Leds.init();
    return SUCCESS;
  }

  command result_t StdControl.start()
  {
    return SUCCESS;
  }

  command result_t StdControl.stop()
  {
    return SUCCESS;
  }

  event TOS_MsgPtr ReceiveMsg.receive( TOS_MsgPtr msg )
  {
    CountMsg_t* body = (CountMsg_t*)msg->data;
    call Leds.set( body->n );
    return msg;
  }
}

