// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/* 
 * Authors:  David Culler, Su Ping
 *           Intel Research Berkeley Lab
 * Date:     7/11/2002
 *
*/

/** 
 *
 * The SenseLightToLog app is used in Lesson 8 of the TinyOS tutorial and it 
 * implements the Sensing and StdControl interface.  When a command to 
 * start sensing is received, it periodically samples the light sensor 
 * for N samples and also store it in the EEPROM.  Once N samples have 
 * been collected, the timer is turned off and the sense done event is
 * signalled.
 *
 * @author tinyos-help@millennium.berkeley.edu
 * @author David Culler
 * @author Su Ping
 * @author Intel Research Berkeley Lab
 */

configuration SenseLightToLog { 
  provides interface Sensing;
}

implementation {

  components Main, SenseLightToLogM, SimpleCmd, LedsC;
  components GenericComm as Comm, TimerC, Logger, Photo;

  Main.StdControl->SenseLightToLogM;

  SenseLightToLogM.Leds -> LedsC;
  SenseLightToLogM.Timer -> TimerC.Timer[unique("Timer")];
  SenseLightToLogM.LoggerWrite -> Logger.LoggerWrite;

  SenseLightToLogM.SubControl -> Comm;
  SenseLightToLogM.SubControl -> Photo;
  SenseLightToLogM.SubControl -> Logger;
 
  SenseLightToLogM.ADC -> Photo;
  Sensing = SenseLightToLogM.Sensing;

}
