// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/*
 *
 * Authors:		Joe Polastre
 * Date last modified:  7/18/02
 *
 */

/**
 * Provides the ability to write or read a series of bytes to/from the
 * I2C bus.  For more information, look at the I2CPacket.ti interface
 * @author Joe Polastre
 **/
configuration I2CPacketSlaveC
{
  provides {
    interface StdControl;
    interface I2CPacketSlave;
    interface ReceiveMsg;
    command result_t setI2CAddress(uint8_t value);
  }
}

implementation {
  components I2CSlaveC, I2CPacketSlaveM, LedsC as Leds;

  StdControl = I2CPacketSlaveM;
  setI2CAddress = I2CPacketSlaveM;
  I2CPacketSlave = I2CPacketSlaveM;
  ReceiveMsg = I2CPacketSlaveM;

  I2CPacketSlaveM.I2CSlave -> I2CSlaveC;
  I2CPacketSlaveM.I2CStdControl -> I2CSlaveC.StdControl;
  I2CPacketSlaveM.Leds -> Leds;
}
