#!/usr/bin/perl

# Script to take BB execution counts generated by TOSSIM and convert them to cycle
# counts

$usage = 
    "Usage: bb2cycle.pl bb_exec_cnt bb_cycle_map\n".
    "       bb_exec_cnt: The basic block execution counts output by TOSSIM\n".
    "       bb_cycle_map: The bb -> cycle count map generated by bb2asm.pl\n\n";  


die $usage if(scalar @ARGV != 2);

$bb_exec_cnt = shift @ARGV;
$bb_cycle_map = shift @ARGV;

open(EXEC_CNT, $bb_exec_cnt) || die "Can't open $bb_exec_cnt: $!";
open(CYCLE_MAP, $bb_cycle_map) || die "Can't open $bb_cycle_map: $!";

while(<CYCLE_MAP>) {
    ($bb, $cnt) = split;
    $cycles{$bb} = $cnt;
}

while(<EXEC_CNT>) {
    ($mote, $bb, $cnt) = split;
    $total{$mote} += $cnt * $cycles{$bb};
}

foreach $mote (sort {$a <=> $b} keys %total) {
    print "$mote\t", $total{$mote}, "\n";
}
close(EXEC_CNT);
close(CYCLE_MAP);
