// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 * Authors:		Joe Polastre
 */

includes IEEE802154;

/**
 * MCPS_PURGE is used to manage MSDU handles in the transaction queue of
 * the MCPS of the MAC sublayer.
 * The MCPS-SAP supports the transport of SSCS protocol data units (SPDUs)
 * between peer SSCS entities.
 *
 * @author Joe Polastre
 */

interface MCPS_PURGE {

  /**
   * Request MSDU to be purged from the transaction queue.
   * See page 62 of the IEEE 802.15.4 specification.
   * 
   * @param msduHandle The handle of the MSDU to be purged from the
   *                   transaction queue
   */
  command void request  (
                          uint8_t msduHandle
                        );

  /**
   * Confirm reports the results of a request to purge a data MSDU.
   * See page 59 of the IEEE 802.15.4 specification.
   *
   * @param msduHandle The handle associated with the MSDU
   * @param status That status of the last MSDU transmission
   */
  event void confirm    (  
                          uint8_t msduHandle,
                          IEEE_status status
                        );

}
