// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 * Authors:		Joe Polastre
 */

includes IEEE802154;

/**
 * The MLME-SAP get primitives define how to read values from the PIB.
 *
 * @author Joe Polastre
 */

interface MLME_GET {

  /**
   * Request to get data of a specific PIB attribute.
   * See page 68 of the IEEE 802.15.4 specification.
   * 
   * @param PIBAttribute identifier of the PIBAttribute to read. 
   *                     PIBAttribute values are defined in Tables 71 and 72
   *                     of the IEEE 802.15.4 specification and in the
   *                     IEEE802154.h header file.
   */
  command void request  (
                          uint8_t PIBAttribute
                        );

  /**
   * Reports the results of an information request from the MAC PIB
   *
   * @param status The status of the association attempt
   * @param PIBAttribute identifier of the PIBAttribute to read. 
   *                     PIBAttribute values are defined in Tables 71 and 72
   *                     of the IEEE 802.15.4 specification and in the
   *                     IEEE802154.h header file.
   * @param PIBAttributeValue value of the PIBAttribute
   */
  event void confirm    (
                          IEEE_status status,
                          uint8_t PIBAttribute,
                          void* PIBAttributeValue
                        );

}
