// $Id$

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 * Authors:		Joe Polastre
 */

includes IEEE802154;

/**
 * The MLME-SAP polling primitives define how to request data from a 
 * coordinator.
 *
 * @author Joe Polastre
 */

interface MLME_POLL {

  /**
   * Prompts the device to request data from the coordinator.
   * See page 106 of the IEEE 802.15.4 specification.
   * 
   * @param CoordAddrMode The addressing mode of the coordinator to which
   *                      the poll is intended
   * @param CoordPANId The PAN identifier of the coordinator to which the
   *                   poll is intended
   * @param CoordAddress The address of the coordinator to which the
   *                     poll is intended
   * @param SecurityEnable TRUE if security is enabled for this transfer
   */
  command void request  (
                          uint8_t CoordAddrMode,
                          uint16_t CoordPANId,
                          uint8_t* CoordAddress,
                          bool SecurityEnable
                        );

  /**
   * Reports the results of a request to poll the coordinator for data
   *
   * @param status The status of the data request
   */
  event void confirm    (
                          IEEE_status status
                        );

}
