enum {
	AM_LRXMSG = 55,
	MAX_BLOCK_SIZE = 26,
	MAX_WINDOW_SIZE = 64,


	MSG_CTRL_OPEN = 1,
	MSG_CTRL_DATA = 2,
	MSG_CTRL_ACK = 3,
	
	STATE_IDLE = 9,
	
	STATE_SEND_OPEN = 11,
	STATE_SEND_DATA = 12,
	STATE_SEND_ACK = 13,
	
	STATE_RECEIVE_OPEN = 21,
	STATE_RECEIVE_DATA = 22,
	STATE_RECEIVE_ACK = 23,
	
	TIMEOUT_OPEN = 5,
	TIMEOUT_DATA = 5,
	TIMEOUT_ACK = 5,
};

typedef struct LRXPkt {
	uint16_t sourceID;
	uint8_t ctrlandBlockNum;
	uint8_t data[MAX_BLOCK_SIZE];
} LRXPkt;

typedef struct LRXOpenMsg {
	uint8_t numofBlock;
	uint8_t desc[MAX_BLOCK_SIZE - 1];
} LRXOpenMsg;

typedef struct LRXAckMsg {
	uint8_t subCtrl;
	uint8_t bitVector[(MAX_WINDOW_SIZE + 7) / 8];
} LRXAckMsg;

