/**
 * Large-scale Reliable Transfer (LRX) Send
 * 
 * Transfer large amount of data reliably.
 *
 * Trnasfer an array of data blocks, which is called data cluster. Each data
 * block fits into one packet.
 * To start transfer, description of data should be given. Receiver can deny
 * data after looking at the description of data. (for example, receiver
 * already has that data)
 *
 * User of LRXSend should provide buffering. When LRXSend asks for
 * a specific block, user should fill up buffer of LRXSend. When LRXReceive
 * gives a pointer to buffer of LRXReceive, user of LRXReceive should copy
 * content to its own buffer, so that LRXReceive can receive next packet
 * into the buffer of LRXReceive.
 *
 * @author Sukun Kim
 * @author Philip Buonadonna
 */
 
interface LRXSend {
	/**
	 * Request send. Send <code>numofBlock</code> blocks to destnation
	 * <code>destID</code>. Give description(<code>desc</code>) of
	 * size(<code>descSize</code>).
	 *
	 * @return SUCCESS if send request accepted, FAIL otherwise.
	 */
	command result_t transfer(uint16_t destID, uint8_t numofBlock,
		uint8_t *desc, uint8_t descSize);
	
	/**
	 * Send completed. <code>success</code> indicates whether the send
	 * was successful or not for data cluster with
	 * description(<code>desc</code>).
	 *
	 * @return SUCCESS always.
	 */
	event result_t transferDone(uint8_t *desc, result_t success);

	/**
	 * Abort sending.
	 *
	 * @return SUCCESS always.
	 */
	command result_t abortSend();

	/**
	 * Data block <code>blockNum</code> is requested. Upper layer should fill
	 * up <code>blockBuf</code>.
	 *
	 * @return Size of requested block.
	 */
	event uint8_t readDataBlock(uint8_t blockNum, uint8_t *blockBuf);
}

