module EasyECM {
	provides {
		interface StdControl;
		interface Send;
		interface Receive;
	}
	uses {
		interface SendMsg;
		interface ReceiveMsg;
		interface ErasureCode;
		interface Leds;
	}
}
implementation {
	bool busy;
	uint8_t buf[MaxM * MaxP];
	uint8_t channel[MaxN * MaxP];
	uint8_t codeNumList[MaxM];
	uint8_t mm;
	uint8_t nn;
	uint8_t pp;

	void dump_buf() {
		uint8_t i, j;
		dbg(DBG_USR1, "dump_buf\n");
		for (i = 0; i < mm; i++) {
			for (j = 0; j < pp; j++) {
				dbg(DBG_USR1, "%d\t", buf[i * pp + j]);
			}
		}
		dbg(DBG_USR1, "\n");
	}
	void dump_channel() {
		uint8_t i, j;
		dbg(DBG_USR1, "dump_channel\n");
		for (i = 0; i < nn; i++) {
			for (j = 0; j < pp; j++) {
				dbg(DBG_USR1, "%d\t", channel[i * pp + j]);
			}
		}
		dbg(DBG_USR1, "\n");
	}
	void dump_codeNumList() {
		uint8_t i;
		dbg(DBG_USR1, "codeNumList\n");
		for (i = 0; i < mm; i++) {
			dbg(DBG_USR1, "%d", codeNumList[i]);
		}
		dbg(DBG_USR1, "\n");
	}
	command result_t StdControl.init() {
		result_t r1 = call Leds.init();
		return r1;
	}
	command result_t StdControl.start() {
		int i, j;
		busy = FALSE;
		mm = 7;
		nn = 35;
		pp = 20;
		for (i = 0; i < mm; i++) {
			for (j = 0; j < pp; j++) {
				buf[i * pp + j] = i + j;
			}
		}
		call ErasureCode.setMsg(mm, pp, buf);
		dump_buf();
		for (i = 0; i < nn; i++) {
			call ErasureCode.getCode(channel + i * pp, i);
		}
		dump_channel();
		for (i = 0; i < mm; i++) {
			for (j = 0; j < pp; j++) {
				buf[i * pp + j] = channel[2 * i * pp + j];
			}
			codeNumList[i] = 2 * i;
		}
		call ErasureCode.setCode(mm, pp, buf, codeNumList);
		dump_codeNumList();
		dump_buf();
		call ErasureCode.decode();
		dump_buf();
		return SUCCESS;
	}
	command result_t StdControl.stop() {
		return SUCCESS;
	}

	command result_t Send.send(TOS_MsgPtr msg, uint16_t length) {
		if (busy) return FAIL;
	}
	command void* Send.getBuffer(TOS_MsgPtr msg, uint16_t* length) {
		if (busy) return NULL;
	}
	default event result_t Send.sendDone(TOS_MsgPtr msg, result_t success) {
		return SUCCESS;
	}
	default event TOS_MsgPtr Receive.receive(TOS_MsgPtr msg, void* payload,
		uint16_t payloadLen) {
		return msg;
	}

	event result_t SendMsg.sendDone(TOS_MsgPtr msg, result_t success) {
		return SUCCESS;
	}
	event TOS_MsgPtr ReceiveMsg.receive(TOS_MsgPtr msg) {
		return msg;
	}
}

