#define SAMPLE_INTERVAL 200000 // us
#define CHANNEL1_SELECT 1 // 0 to exclude, 1 to include
#define CHANNEL2_SELECT 1
#define CHANNEL3_SELECT 1
#define CHANNEL4_SELECT 1	// value of channel 4 is reversed again
							// to produce correct value

module ContSenseM {
	provides interface StdControl;
	uses {
		interface SendMsg;
		interface MicroTimer;
		interface Leds;
	}
}
implementation {
	norace char head;
	norace uint8_t currentBuffer;
	norace uint16_t readingNumber;

	norace TOS_Msg dataBuffer1[2];
	norace uint16_t* bufferPtr1[2];
	norace TOS_Msg dataBuffer2[2];
	norace uint16_t* bufferPtr2[2];
	norace TOS_Msg dataBuffer3[2];
	norace uint16_t* bufferPtr3[2];
	norace TOS_Msg dataBuffer4[2];
	norace uint16_t* bufferPtr4[2];

	norace int channel_index;
	norace bool channel_select[4];
	uint8_t spacer;

	task void sendBuffer1();
	task void sendBuffer2();
	task void sendBuffer3();
	task void sendBuffer4();

	void send_next_channel() {
		while (!channel_select[channel_index]) {
			channel_index++;
		}
		if (channel_index == 0) {
			post sendBuffer1();
		} else if (channel_index == 1) {
			post sendBuffer2();
		} else if (channel_index == 2) {
			post sendBuffer3();
		} else if (channel_index == 3) {
			post sendBuffer4();
		} else {
			channel_index = 0;
		}
	}

	void sample_acc() {
		int i;
		uint8_t read_value[22];
		uint16_t accelerometer1 = 0;
		uint16_t accelerometer2 = 0;
		uint16_t accelerometer3 = 0;
		uint16_t accelerometer4 = 0;
		
		atomic {
			outp(0x00, PORTC);
			for (i = 0; i < 22; i++) {
				read_value[i] = inp(PINE);
				outp(0x05, PORTC);
				spacer+=i;spacer+=i;spacer+=i;spacer+=i;spacer+=i;
				spacer+=i;spacer+=i;spacer+=i;spacer+=i;spacer+=i;
				outp(0x00, PORTC);
			}
			outp(0x0a, PORTC);
		}

		for (i = 6; i < 22; i++) {
			accelerometer1 <<= 1;
			accelerometer2 <<= 1;
			accelerometer3 <<= 1;
			accelerometer4 <<= 1;
			if (read_value[i] & 0x80) accelerometer1 |= 1;
			if (read_value[i] & 0x40) accelerometer2 |= 1;
			if (read_value[i] & 0x20) accelerometer3 |= 1;
			if (read_value[i] & 0x10) accelerometer4 |= 1;
		}

		bufferPtr1[currentBuffer][(int)head] = accelerometer1;
		bufferPtr2[currentBuffer][(int)head] = accelerometer2;
		bufferPtr3[currentBuffer][(int)head] = accelerometer3;
		bufferPtr4[currentBuffer][(int)head] = 0xffff - accelerometer4;
		readingNumber++;
		head++;

		if (head == BUFFER_SIZE) {
			head = 0;
			currentBuffer ^= 0x01;
			channel_index = 0;
			send_next_channel();
		}
	}

	command result_t StdControl.init() {
		call Leds.init();
		call MicroTimer.start(SAMPLE_INTERVAL);

		head = 0;
		currentBuffer = 0;
		readingNumber = 0;

		bufferPtr1[0] = ((struct OscopeMsg*)(dataBuffer1[0].data))->data;
		bufferPtr1[1] = ((struct OscopeMsg*)(dataBuffer1[1].data))->data;

		bufferPtr2[0] = ((struct OscopeMsg*)(dataBuffer2[0].data))->data;
		bufferPtr2[1] = ((struct OscopeMsg*)(dataBuffer2[1].data))->data;

		bufferPtr3[0] = ((struct OscopeMsg*)(dataBuffer3[0].data))->data;
		bufferPtr3[1] = ((struct OscopeMsg*)(dataBuffer3[1].data))->data;

		bufferPtr4[0] = ((struct OscopeMsg*)(dataBuffer4[0].data))->data;
		bufferPtr4[1] = ((struct OscopeMsg*)(dataBuffer4[1].data))->data;

		channel_index = 0;
		channel_select[0] = CHANNEL1_SELECT;
		channel_select[1] = CHANNEL2_SELECT;
		channel_select[2] = CHANNEL3_SELECT;
		channel_select[3] = CHANNEL4_SELECT;

		outp(0xff, DDRC);
		outp(0x0e, DDRE);
		outp(0x0a, PORTC);

		return SUCCESS;
	}
	command result_t StdControl.start() {
		return SUCCESS;
	}
	command result_t StdControl.stop() {
		return SUCCESS;
	}

	task void sendBuffer1()
	{
		struct OscopeMsg* temp_OscopeMsg =
			(struct OscopeMsg*)dataBuffer1[currentBuffer^0x01].data;
		temp_OscopeMsg->sourceMoteID = TOS_LOCAL_ADDRESS;
		temp_OscopeMsg->lastSampleNumber = readingNumber;
		temp_OscopeMsg->channel = 1;
		//call Leds.redToggle();
		call SendMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
			&dataBuffer1[currentBuffer^0x01]);
	}
	task void sendBuffer2()
	{
		struct OscopeMsg* temp_OscopeMsg =
			(struct OscopeMsg*)dataBuffer2[currentBuffer^0x01].data;
		temp_OscopeMsg->sourceMoteID = TOS_LOCAL_ADDRESS;
		temp_OscopeMsg->lastSampleNumber = readingNumber;
		temp_OscopeMsg->channel = 2;
		//call Leds.redToggle();
		call SendMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
			&dataBuffer2[currentBuffer^0x01]);
	}
	task void sendBuffer3()
	{
		struct OscopeMsg* temp_OscopeMsg =
			(struct OscopeMsg*)dataBuffer3[currentBuffer^0x01].data;
		temp_OscopeMsg->sourceMoteID = TOS_LOCAL_ADDRESS;
		temp_OscopeMsg->lastSampleNumber = readingNumber;
		temp_OscopeMsg->channel = 3;
		//call Leds.redToggle();
		call SendMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
			&dataBuffer3[currentBuffer^0x01]);
	}
	task void sendBuffer4()
	{
		struct OscopeMsg* temp_OscopeMsg =
			(struct OscopeMsg*)dataBuffer4[currentBuffer^0x01].data;
		temp_OscopeMsg->sourceMoteID = TOS_LOCAL_ADDRESS;
		temp_OscopeMsg->lastSampleNumber = readingNumber;
		temp_OscopeMsg->channel = 4;
		//call Leds.redToggle();
		call SendMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
			&dataBuffer4[currentBuffer^0x01]);
	}

	event result_t SendMsg.sendDone(TOS_MsgPtr msg, result_t success)
	{
		call Leds.redToggle();
		channel_index++;
		send_next_channel();
		return SUCCESS;
	}

	async event result_t MicroTimer.fired()
	{
		sample_acc();
		return SUCCESS;
	}
}

