includes SimpleCmdMsg;
includes OscopeMsg;
includes CtrlMsg;
includes HFS;
configuration AccelReader
{
}
implementation
{
	components Main, AccelReaderM, GenericComm,
		/*Accel as Sensor,*/ LedsC;
	components Sample, MicroTimerM, BufferedLog, ByteEEPROM;

	Main.StdControl -> AccelReaderM;
	Main.StdControl -> GenericComm;
//	Main.StdControl -> Sensor;
	Main.StdControl -> ByteEEPROM;

	AccelReaderM.Sampling -> Sample;
	AccelReaderM.AllocationReq -> ByteEEPROM.AllocationReq[HFS_EEPROM_ID];
	AccelReaderM.ReadData -> ByteEEPROM.ReadData[HFS_EEPROM_ID];

	AccelReaderM.ReceiveCmdMsg -> GenericComm.ReceiveMsg[AM_SIMPLECMDMSG];
	AccelReaderM.SendDataMsg -> GenericComm.SendMsg[AM_OSCOPEMSG];
	AccelReaderM.SendCtrlMsg -> GenericComm.SendMsg[AM_CTRLMSG];

//	AccelReaderM.ADC1 -> Sensor.AccelX;
//	AccelReaderM.ADC2 -> Sensor.AccelY;
/*
	AccelReaderM.EEPROMRead -> EEPROM.EEPROMRead;
	AccelReaderM.EEPROMWrite -> EEPROM.EEPROMWrite[unique("EEPROMWrite")];
	AccelReaderM.Timer -> TimerC.Timer[unique("Timer")];
*/
	AccelReaderM.Leds -> LedsC;

	Sample.LogData -> BufferedLog;
	Sample.fastAppend -> BufferedLog;
	Sample.ExternalShutdown -> GenericComm;
	Sample.MicroTimer -> MicroTimerM;
//	Sample.ADC -> Sensor.AccelX;
	Sample.Leds -> LedsC;

	BufferedLog.Logger -> ByteEEPROM.LogData[HFS_EEPROM_ID];
}

