includes SimpleCmdMsg;
includes OscopeMsg;
includes CtrlMsg;
includes EEPROM;
#define MAX_LOGGER_DATA_SIZE 8
module AccelReaderM
{ 
	provides { 
		interface StdControl;
	}
	uses {
		interface ReceiveMsg as ReceiveCmdMsg;
		interface SendMsg as SendDataMsg;
		interface SendMsg as SendCtrlMsg;

//		interface ADC as ADC1;
//		interface ADC as ADC2;
//		interface EEPROMRead;
//		interface EEPROMWrite;
//		interface Timer;
		interface Leds;

    interface Sampling;
    interface AllocationReq;
    interface ReadData;
	}
}
implementation 
{
	TOS_MsgPtr cur_msg;  // The current command message
	bool sensing_pending;
	uint16_t curReadLine, curWriteLine;

	norace int head;
	norace uint8_t currentBuffer;
	int sensorBuffer[2*MAX_LOGGER_DATA_SIZE];
	norace int *bufferPtr[2];
	int nsamples;
	uint16_t start_time;
	uint16_t finish_time;

	int buffer_head;
	int packet_head;
	uint16_t bufferData[MAX_LOGGER_DATA_SIZE];
	TOS_Msg bufferPacket1;
	TOS_Msg bufferPacket2;
	uint16_t readingNumber;
	int current_channel;
	int ndata;

	int phase;
	uint8_t state;

// from HFS
  // green: ready, red: error, yellow: sampling
  bool ready;
  TOS_Msg temp_msg;
  uint32_t dataEnd;
  struct SampleRequestMsg o;	/* outside sampling orders */

  uint32_t offset, remain;

  void setReady() {
    ready = TRUE;
    call Leds.greenOn();
  }

  void notReady() {
    ready = FALSE;
    call Leds.greenOff();
  }

  event result_t AllocationReq.requestProcessed(result_t success) {
    // Allocation must succeed
    if (success)
      setReady();
    return SUCCESS;
  }

  task void doSampling();
/*
  event TOS_MsgPtr ReceiveMsg.receive(TOS_MsgPtr m) {
    o = *(struct SampleRequestMsg *)m->data;
    post doSampling();
    return m;
  }
*/

  void sendMsg(uint8_t outcome) {
/*
    struct SampleDoneMsg *m = (struct SampleDoneMsg *)msg.data;
    m->outcome = outcome;
    m->bytesUsed = dataEnd;
    call SendMsg.send(TOS_BCAST_ADDR, sizeof *m, &msg);
*/
  }
/*
  event result_t SendMsg.sendDone(TOS_MsgPtr m, result_t ok) {
    return SUCCESS;
  }
*/
  // Report sampling completion
  void complete(uint8_t outcome) {
    setReady();
    if (outcome == SAMPLE_FAILED)
      call Leds.redOn();
	sensing_pending = FALSE;
    sendMsg(outcome);
  }

  task void doSampling() {
    if (!ready)
      sendMsg(SAMPLE_NOTREADY);

    call Leds.redOff();
    notReady();

    if (o.sampleCount > MAX_SAMPLES ||
	!call Sampling.prepare(o.sampleInterval, o.sampleCount))
      complete(SAMPLE_FAILED);
  }

  event result_t Sampling.ready(result_t ok) {
    call Leds.yellowOn();
    if (!ok || !call Sampling.start()) {
      complete(SAMPLE_FAILED);
	  call Leds.yellowOff();
	}
    return SUCCESS;
  }

	void sendLog();
  event result_t Sampling.done(result_t ok, uint32_t lastOffset) {
    dataEnd = lastOffset;
    call Leds.yellowToggle();
    complete(ok ? SAMPLE_SUCCESS : SAMPLE_FAILED);
//	offset = 0;
	//sendLog();
    return SUCCESS;
  }

// from HFSRead

  enum {
    BYTES_PER_MSG = sizeof temp_msg.data - 1
  };

  void fail() {
    temp_msg.data[0] = DATAMSG_FAIL;
//    call SendMsg.send(TOS_BCAST_ADDR, 1, &msg);
  }

  task void sendData() {
    uint8_t n;

    if (remain < BYTES_PER_MSG)
      {
	n = remain;
	temp_msg.data[0] = DATAMSG_LAST;
      }
    else
      {
	n = BYTES_PER_MSG;
	temp_msg.data[0] = DATAMSG_MORE;
      }

    if (!call ReadData.read(offset, temp_msg.data + 1, n))
      fail();
  }

  event result_t ReadData.readDone(uint8_t *buffer, uint32_t bytes, result_t ok) {
    uint8_t n = remain < BYTES_PER_MSG ? remain : BYTES_PER_MSG;

    if (ok)//&& call SendMsg.send(TOS_BCAST_ADDR, n + 1, &msg))
      {
	offset += MAX_LOGGER_DATA_SIZE * 2;
	remain -= n;
	sendLog();
      }
    else
      fail();

    return SUCCESS;
  }
/*
  event result_t SendMsg.sendDone(TOS_MsgPtr m, result_t ok) {
    if (ok)
      {
	if (remain)
	  post sendData();
      }
    else
      fail();

    return SUCCESS;
  }

  event TOS_MsgPtr ReceiveMsg.receive(TOS_MsgPtr m) {
    struct ReadRequestMsg *orders = (struct ReadRequestMsg *)m->data;
    offset = 0;
    remain = orders->count * sizeof(sample_t);
    post sendData();
    return m;
  }
*/


	task void cmdInterpret() {
		struct SimpleCmdMsg *cmd = (struct SimpleCmdMsg *)cur_msg->data;
		struct CtrlMsg *ctrlPkt;
		int i;
		state = cmd->action;
		// Execute the command
		switch (cmd->action) {
		case LED_ON:
			call Leds.yellowOn();
			break;
		case LED_OFF:
			call Leds.yellowOff();
			break;
		case RADIO_QUIETER:
			break;
		case RADIO_LOUDER:
			break;
		case START_SENSING:
			if (cmd->args.ss_args.channel_selection) {
				if (!sensing_pending) {
					sensing_pending = TRUE;
					phase = 1;
					nsamples = cmd->args.ss_args.nsamples;
					ndata += cmd->args.ss_args.nsamples;
					start_time = inw(TCNT3L);
/*
				call Leds.redOn();
				call EEPROMWrite.startWrite();
				call Timer.start(TIMER_REPEAT, cmd->args.ss_args.interval);
*/
				    if (!ready)
				      sendMsg(SAMPLE_NOTREADY);

				    call Leds.redOff();
				    notReady();

				    if (nsamples > MAX_SAMPLES ||
					!call Sampling.prepare(cmd->args.ss_args.interval, nsamples))
				      complete(SAMPLE_FAILED); 
					//sensing_pending = FALSE;
				}
			} else {
				finish_time = inw(TCNT3L);
			}
			break;
		case READ_LOG:
			if (!sensing_pending) {
				sensing_pending = TRUE;
				//ndata += cmd->args.rl_args.destaddr;
				//offset = 0;
				//sendLog();
				ctrlPkt = (struct CtrlMsg *)bufferPacket1.data;
				ctrlPkt->sourceMoteID = TOS_LOCAL_ADDRESS;
				ctrlPkt->controlNumber = TIME_REPORT;
				ctrlPkt->args.tr_args.start_time = start_time;
				ctrlPkt->args.tr_args.finish_time = finish_time;
				call SendCtrlMsg.send(TOS_BCAST_ADDR, sizeof(struct CtrlMsg),
					&bufferPacket1);
    		}
			break;
		case PING_NODE:
			if (cmd->args.pn_args.destaddr == TOS_LOCAL_ADDRESS) {
				ctrlPkt = (struct CtrlMsg *)bufferPacket1.data;
				ctrlPkt->sourceMoteID = TOS_LOCAL_ADDRESS;
				ctrlPkt->controlNumber = PING_REPLY;
//				call Leds.yellowToggle();
				call SendCtrlMsg.send(TOS_BCAST_ADDR, sizeof(struct CtrlMsg),
					&bufferPacket1);
			}
			break;
		case FIND_NODE:
			for (i = 0; i < MAX_FIND_NODE_ARGS; i++) {
				if (cmd->args.fn_args.nodes[i] == TOS_LOCAL_ADDRESS) {
    				break;
				}
			}
			if (i == MAX_FIND_NODE_ARGS) {
				ctrlPkt = (struct CtrlMsg *)bufferPacket1.data;
				ctrlPkt->sourceMoteID = TOS_LOCAL_ADDRESS;
				ctrlPkt->controlNumber = FIND_REPLY;
//				call Leds.redToggle();
				call SendCtrlMsg.send(TOS_BCAST_ADDR, sizeof(struct CtrlMsg),
					&bufferPacket1);
			}
			break;
		default:
		}
	}

	void sendLog() {
		struct OscopeMsg *pack1 = (struct OscopeMsg *)bufferPacket1.data;
		struct OscopeMsg *pack2 = (struct OscopeMsg *)bufferPacket2.data;
		while (buffer_head != MAX_LOGGER_DATA_SIZE &&
				packet_head != BUFFER_SIZE) {
			pack1->data[packet_head] = bufferData[buffer_head];
			buffer_head++;
			pack2->data[packet_head] = bufferData[buffer_head];
			buffer_head++;
			packet_head++;
			readingNumber++;
		}
		if (packet_head == BUFFER_SIZE) {
//			call Leds.yellowToggle();
			pack1->sourceMoteID = TOS_LOCAL_ADDRESS;
			pack1->lastSampleNumber = readingNumber - 9;
			pack1->channel = 1;
			pack2->sourceMoteID = TOS_LOCAL_ADDRESS;
			pack2->lastSampleNumber = readingNumber - 9;
			pack2->channel = 2;

			packet_head = 0;
			current_channel = 1;
			call SendDataMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
				&bufferPacket1);
		} else if (buffer_head == MAX_LOGGER_DATA_SIZE) {
//			call Leds.redToggle();
			if (ndata >= 4) {
				ndata -= 4;
				buffer_head = 0;
				call ReadData.read(offset, (uint8_t *)bufferData,
					MAX_LOGGER_DATA_SIZE * 2);
//				call EEPROMRead.read(curReadLine, (uint8_t *)bufferData);
			} else { // done
				call Leds.greenOff();
				sensing_pending = FALSE;
			}
		} else {
			//error
			call Leds.yellowOn();
		}
	}

	task void sendLogTask()
	{
		sendLog();
	}

	command result_t StdControl.init() {
		call Leds.init();
		sensing_pending = FALSE;
		curReadLine = EEPROM_LOGGER_APPEND_START;
		curWriteLine = EEPROM_LOGGER_APPEND_START;

		head = 0;
		currentBuffer = 0;
		bufferPtr[0] = &(sensorBuffer[0]);
		bufferPtr[1] = &(sensorBuffer[MAX_LOGGER_DATA_SIZE]);

		buffer_head = MAX_LOGGER_DATA_SIZE;
		packet_head = 0;
		readingNumber = 0;
		ndata = 0;

		call AllocationReq.request(MAX_SAMPLES * sizeof(sample_t));
		offset = 0;
		
		outp(0x41, TCCR3B);// set clock source
		// disable output comparation interrupt
		cbi(TIMSK, OCIE3A);
		cbi(TIMSK, OCIE3B);
	
		return SUCCESS;
	}
	command result_t StdControl.start() {
		return SUCCESS;
	}
	command result_t StdControl.stop() {
		return SUCCESS;
	}

	event TOS_MsgPtr ReceiveCmdMsg.receive(TOS_MsgPtr msg) {
		cur_msg = msg;
		post cmdInterpret();
		return msg;
	}
	event result_t SendDataMsg.sendDone(TOS_MsgPtr msg, result_t success) {
		if (current_channel == 1) {
			current_channel++;
			call SendDataMsg.send(TOS_BCAST_ADDR, sizeof(struct OscopeMsg),
				&bufferPacket2);
		} else {
			sendLog();
		}
		return SUCCESS;
	}
	event result_t SendCtrlMsg.sendDone(TOS_MsgPtr msg, result_t success) {
		//call Leds.greenOn();
		//`call Leds.yellowOn();
		if (state == READ_LOG) {
			sendLog();
		}
		return SUCCESS;
	}
	/*
	async event result_t ADC1.dataReady(uint16_t data) {
		bufferPtr[currentBuffer][head] = data;
		head++;
		return call ADC2.getData();
	}
	async event result_t ADC2.dataReady(uint16_t data) {
		bufferPtr[currentBuffer][head] = data;
		head++;
		if (head == MAX_LOGGER_DATA_SIZE) {
			head = 0;
			currentBuffer ^= 0x01;
			/
			call EEPROMWrite.write(curWriteLine,
				(uint8_t *)bufferPtr[currentBuffer^0x01]);
				/
		}
		return SUCCESS;
	}
	*/
	/*
	event result_t EEPROMRead.readDone(uint8_t *buffer, result_t success)
	{
		curReadLine++;
		if (curReadLine == EEPROM_LOGGER_APPEND_END)
			curReadLine = EEPROM_LOGGER_APPEND_START;
		sendLog();
		return SUCCESS;
	}
	event result_t EEPROMWrite.writeDone(uint8_t *buffer)
	{
		curWriteLine++;
		if (curWriteLine == EEPROM_LOGGER_APPEND_END)
			curWriteLine = EEPROM_LOGGER_APPEND_START;
		return SUCCESS;
	}
	event result_t EEPROMWrite.endWriteDone(result_t success)
	{
		return SUCCESS;
	}
	event result_t Timer.fired() {
//		call Leds.yellowToggle();
		if (phase == 2) {
			sendLog();
		}
		else {
			if (nsamples== 0) {
				call Timer.stop();
				call EEPROMWrite.endWrite();
				phase = 2;
				call Timer.start(TIMER_ONE_SHOT, 1000);
				call Leds.redOff();
				call Leds.greenOn();
			} else {
				nsamples--;
				call ADC1.getData();
			}
		}
		return SUCCESS;
	}
	*/
}

