includes HFS;
configuration HFS { }
implementation {
  components Main, HFSM, HFSRead;
  components Sample, MicroTimerM;
  components BufferedLog, ByteEEPROM;
  components /*Accel as Sensor,*/ GenericComm as Comm, LedsC;

  Main.StdControl -> HFSM;
  Main.StdControl -> ByteEEPROM;
  Main.StdControl -> Comm;
//  Main.StdControl -> Sensor;

  HFSM.Sampling -> Sample;
  HFSM.ReceiveMsg -> Comm.ReceiveMsg[AM_SAMPLEREQUESTMSG];
  HFSM.SendMsg -> Comm.SendMsg[AM_SAMPLEDONEMSG];
  HFSM.AllocationReq -> ByteEEPROM.AllocationReq[HFS_EEPROM_ID];
  HFSM.Leds -> LedsC;

  Sample.LogData -> BufferedLog;
  Sample.fastAppend -> BufferedLog;
  Sample.ExternalShutdown -> Comm;
  Sample.MicroTimer -> MicroTimerM;
//  Sample.ADC -> Sensor.AccelX;

  BufferedLog.Logger -> ByteEEPROM.LogData[HFS_EEPROM_ID];

  HFSRead.ReceiveMsg -> Comm.ReceiveMsg[AM_READREQUESTMSG];
  HFSRead.SendMsg -> Comm.SendMsg[AM_READDATAMSG];
  HFSRead.ReadData -> ByteEEPROM.ReadData[HFS_EEPROM_ID];
}
