module Sample {
  provides interface Sampling;
  uses {
    interface LogData;
    async command result_t fastAppend(uint8_t *data, uint8_t n);

    // Interface to shutdown external components that will interfere with
    // high-speed sampling
    interface StdControl as ExternalShutdown;

    interface MicroTimer;
//    interface ADC;
	interface Leds;
  }
}
implementation {
  bool busy;
  norace bool sampling;
  uint32_t sampleInterval;
  norace uint32_t sampleCount;

  uint16_t prev_ddrc;
  uint16_t prev_ddre;

  norace uint16_t actual_interval;
  uint16_t previous_time;

  bool first_time = TRUE;
  uint16_t total_count;
  uint16_t debug_counter;
  uint8_t spacer;
  
  /* Stop sampling and restart external components when sampling fails */
  result_t check(result_t result) {
	if (!result)
      {
	call ExternalShutdown.start();
	busy = FALSE;
      }
    return result;
  }

  command result_t Sampling.prepare(uint32_t interval, uint32_t count) {
	bool check_result;
    if (busy)
      return FAIL;

    sampleInterval = interval;
    sampleCount = count + 1; // the last timer event turns everything off
	total_count = count;
	debug_counter = 0;

    if (!call ExternalShutdown.stop())
      return FAIL;
	
    busy = TRUE;
	prev_ddrc = inw(DDRC);
	prev_ddre = inw(DDRE);
	outp(0xff, DDRC);
	outp(0x0e, DDRE);
	outp(0x0a, PORTC);

    if (first_time) {
        first_time = FALSE;
        check_result = check(call LogData.erase());
    } else {
        check_result = check(SUCCESS);
        signal Sampling.ready(check(SUCCESS));
    }
    return check_result;	
  }

  event result_t LogData.eraseDone(result_t ok) {
    // Sampling can start if we successfully erased the EEPROM
    signal Sampling.ready(check(ok));
    return SUCCESS;
  }

  command result_t Sampling.start() {
    // Sampling starts as long as the MicroTimer is happy
    sampling = FALSE;
    return check(call MicroTimer.start(sampleInterval));
  }

  // Sampling is complete, restart external components and report status
  void complete(result_t result, uint32_t lastOffset) {
   	outp(prev_ddrc, DDRC);
	outp(prev_ddre, DDRE);
    call ExternalShutdown.start();
    busy = FALSE;
    signal Sampling.done(result, lastOffset);
  }

  task void failed() {
    // ADC.dataReady may reenter and post this twice
    if (busy)
      complete(FAIL, 0);
  }

  task void done();

	void sample_acc() {
		int i; //,h;
		uint8_t read_value[26];
		uint16_t accelerometer1 = 0;
		uint16_t accelerometer2 = 0;
		uint16_t accelerometer3 = 0;
		uint16_t accelerometer4 = 0;
//		uint32_t sum_acc1 = 0;
//		uint32_t sum_acc2 = 0;
//		uint32_t sum_acc3 = 0;
//		uint32_t sum_acc4 = 0;
		norace static uint8_t data[sizeof(sample_t) * 2];

//		outp(0xff, DDRC);
//		outp(0x0e, DDRE);
//		outp(0x0a, PORTC);

//		for (h = 0; h < 16; h++) {
		atomic {
			outp(0x00, PORTC);
			for (i = 0; i < 22; i++) {
				read_value[i] = inp(PINE);
				outp(0x05, PORTC);
				spacer+=i;spacer+=i;spacer+=i;spacer+=i;spacer+=i;
				spacer+=i;spacer+=i;spacer+=i;spacer+=i;spacer+=i;
				outp(0x00, PORTC);
			}
			outp(0x0a, PORTC);
		}
			accelerometer1 = 0;
			accelerometer2 = 0;
			accelerometer3 = 0;
			accelerometer4 = 0;
			for (i = 6; i < 22; i++) {
				accelerometer1 <<= 1;
				accelerometer2 <<= 1;
				accelerometer3 <<= 1;
				accelerometer4 <<= 1;
				if (read_value[i] & 0x80) accelerometer1 |= 1;
				if (read_value[i] & 0x40) accelerometer2 |= 1;
				if (read_value[i] & 0x20) accelerometer3 |= 1;
				if (read_value[i] & 0x10) accelerometer4 |= 1;
			}
//			sum_acc1 += accelerometer1;
//			sum_acc2 += accelerometer2;
//			sum_acc3 += accelerometer3;
//			sum_acc4 += accelerometer4;
//		}
//		sum_acc1 >>= 4;
//		sum_acc2 >>= 4;
//		sum_acc3 >>= 4;
//		sum_acc4 >>= 4;

		//accelerometer3 = debug_counter++;
		/*
		if (!(accelerometer2 % 8)) {
			debug_counter++;
			accelerometer3 = 100;
			if (debug_counter > total_count / 2) {
				accelerometer3 = 200;
			}
		}
		*/
		data[0] = accelerometer1;
		data[1] = accelerometer1 >> 8;
//	data[0] = d;
//	data[1] = d >> 8;
//		if (d > 10000) call Leds.redOn();
		data[2] = accelerometer2;
		data[3] = accelerometer2 >> 8;
		if (!call fastAppend(data, sizeof(data))) {
			call MicroTimer.stop();
			post failed();
		}
		atomic sampling = FALSE;
 
/*


		if (acc_select == 14) {
			bufferPtr[currentBuffer][head] = sum_acc1;
			head++;
			bufferPtr[currentBuffer][head] = sum_acc4;
			head++;
		}
		else if (acc_select == 23) {
			bufferPtr[currentBuffer][head] = sum_acc2;
			head++;
			bufferPtr[currentBuffer][head] = sum_acc3;
			head++;
		}
		else {

			bufferPtr[currentBuffer][head] = 0;
			head++;
			bufferPtr[currentBuffer][head] = 0;
			head++;

			bufferPtr[currentBuffer][head] =
				(uint16_t)(stamp_time.low32 & 0xffff);
			head++;
			bufferPtr[currentBuffer][head] =
				(uint16_t)((stamp_time.low32 >> 16) & 0xffff);
			head++;
		}

		if (head == MAX_LOGGER_DATA_SIZE) {
			head = 0;
			currentBuffer ^= 0x01;
			call EEPROMWrite.write(curWriteLine,
				(uint8_t *)bufferPtr[currentBuffer^0x01]);
		}
*/
	}
	
	async event result_t MicroTimer.fired() {
		uint16_t temp_time = 0;
//		temp_time = inw(TCNT3L);
		actual_interval = temp_time - previous_time;
		previous_time = temp_time;
//		actual_interval = inw(TCNT3L);
//		outp(0, TCNT3H);
//		outp(0, TCNT3L);
		if (!--sampleCount) {
			call MicroTimer.stop();
			post done();
		} else if (sampling) {// || !call ADC.getData()) {
			call MicroTimer.stop();
			post failed();
		} else {
		   	sampling = TRUE;
			sample_acc();
		}
		return SUCCESS;
	}

/*
	async event result_t MicroTimer.fired() {
	    // On the "extra" sample we just stop the timer and signal completion
	    // (signaling completion after collecting the sample has races due
	    // to reentrancy in the ADC event at the highest frequencies).
	    // If you're worried about this delay then you probably didn't need
	    // high-frequency sampling to the EEPROM...
		actual_interval = inw(TCNT3L);
		outp(0, TCNT3H);
		outp(0, TCNT3L);
		if (!--sampleCount) {
			call MicroTimer.stop();
			post done();
		} else if (sampling || !call ADC.getData()) {
			call MicroTimer.stop();
			post failed();
		} else {
	    	sampling = TRUE;
		}
		return SUCCESS;
	}
*/
/*
  async event result_t ADC.dataReady(uint16_t d) {
    norace static uint8_t data[sizeof(sample_t) * 2];

    // This *must* be correct for the sample_t type...
    data[0] = actual_interval;
    data[1] = actual_interval >> 8;
//	data[0] = d;
//	data[1] = d >> 8;
	if (d > 10000) call Leds.redOn();
	data[2] = 0;
	data[3] = 0;
    if (!call fastAppend(data, sizeof data))
      {
	call MicroTimer.stop();
	post failed();
      }
    atomic sampling = FALSE;
    return SUCCESS;
  }
*/
  task void done() {
    // Save append offset in handy global
    sampleInterval = call LogData.currentOffset();
    if (!call LogData.sync())
      complete(FAIL, 0);
//	complete(SUCCESS, sampleInterval);
  }

  event result_t LogData.syncDone(result_t result) {
    complete(result, sampleInterval);
    return SUCCESS;
  }

  event result_t LogData.appendDone(uint8_t* data, uint32_t numBytes, result_t success) {
    return SUCCESS;
  }
}
