enum {
 AM_SIMPLECMDMSG = 8,
 AM_LOGMSG=9
};

enum {
  LED_ON = 1,
  LED_OFF = 2,
  RADIO_LOUDER  = 3,
  RADIO_QUIETER = 4,
  START_SENSING = 5,
  READ_LOG = 6,
  PING_NODE = 7,
  FIND_NODE = 8,

  MAX_FIND_NODE_ARGS = 12
};

typedef struct {
    int nsamples;
    uint32_t interval;
	uint8_t channel_selection;
} start_sense_args;

typedef struct {
    uint16_t destaddr;
} read_log_args;

typedef struct {
	uint16_t destaddr;
} ping_node_args;

typedef struct {
	uint16_t nodes[MAX_FIND_NODE_ARGS];
} find_node_args;

// SimpleCmd message structure
typedef struct SimpleCmdMsg {
    int8_t seqno;
    int8_t action;
    uint16_t source;
    uint8_t hop_count;
    union {
      start_sense_args ss_args;
      read_log_args rl_args;
	  ping_node_args pn_args;
	  find_node_args fn_args;
      uint8_t untyped_args[0];
    } args;
} SimpleCmdMsg;

// Log message structure
typedef struct LogMsg {
    uint16_t sourceaddr; 
    uint8_t log[16];
} LogMsg;

