includes OscopeMsg;

configuration Oscilloscope { }
implementation
{
  components Main, OscilloscopeM, TimerC, LedsC, TC77M, GenericComm as Comm;

  Main.StdControl -> OscilloscopeM;
  Main.StdControl -> TimerC;
  
  OscilloscopeM.Timer -> TimerC.Timer[unique("Timer")];
  OscilloscopeM.Leds -> LedsC;
  OscilloscopeM.SensorControl -> TC77M;
  OscilloscopeM.ADC -> TC77M;
  OscilloscopeM.CommControl -> Comm;
  OscilloscopeM.ResetCounterMsg -> Comm.ReceiveMsg[AM_OSCOPERESETMSG];
  OscilloscopeM.DataMsg -> Comm.SendMsg[AM_OSCOPEMSG];

  TC77M.Timer -> TimerC.Timer[unique("Timer")];
}

