package net.tinyos.log;

import net.tinyos.util.*;
import java.io.*;
import java.util.Properties;
import net.tinyos.message.*;

public class BcastInject implements MessageListener {
    static Properties p = new Properties();
    public static final byte LED_ON = 1;
    public static final byte LED_OFF = 2;
    public static final byte RADIO_LOUDER = 3;
    public static final byte RADIO_QUIETER = 4;
    public static final byte START_SENSING = 5;
    public static final byte READ_LOG = 6;
	public static final byte PING_NODE = 7;
	public static final byte FIND_NODE = 8;

	public static final byte TIME_REPORT = 1;
	public static final byte PING_REPLY = 2;
	public static final byte FIND_REPLY = 3;

    public boolean read_log_done = false; 
        
    public static final short TOS_BCAST_ADDR = (short) 0xffff;



	private static final int max_retry = 1;
	private static final int max_channel = 4;
	private static final int round_trip = 200;

	private static long nsamples;
	private static long interval;
	private static boolean[] channel_selection = new boolean[max_channel];
	private static int num_mote;
	private static int last_mote_index;
	private static int[] mote_num = new int[50];
	private static boolean[] mote_valid = new boolean[50];
	private static boolean reply_flag;
	
	private static FileOutputStream[] fos = new FileOutputStream[max_channel];
	private static PrintWriter[] pw = new PrintWriter[max_channel];

	private static int start_time;
	private static int finish_time;
	private static int mote_index;
	private static int channel_index;


	
    public static void usage() {
	System.err.println("Usage: java net.tinyos.tools.BcastInject"+
			   " <command> [arguments]");
	System.err.println("\twhere <command> and [arguments] can be one of the following:");
	System.err.println("\t\tled_on");
	System.err.println("\t\tled_off");
	System.err.println("\t\tradio_louder");
	System.err.println("\t\tradio_quieter");
	System.err.println("\t\tstart_sensing [nsamples interval_ms]");
	System.err.println("\t\tread_log [dest_address]");
 	System.err.println("\t\tping node [dest_address]");
 	System.err.println("\t\tfind_node");
	System.err.println("\t\tupdate_nodelist");
    }

    public static void startSensingUsage() {
	System.err.println("Usage: java net.tinyos.tools.BcastInject"
			   + " start_sensing [num_samples interval_ms]");
    }
    public static void  readLogUsage() {
	System.err.println("Usage: java net.tinyos.tools.BcastInject" +
			   " read_log [dest_address]");
    } 
    public static void  pingNodeUsage() {
	System.err.println("Usage: java net.tinyos.tools.BcastInject" +
			   " ping_node [dest_address]");
    } 

    public static byte restoreSequenceNo() {
	try {
	    FileInputStream fis = new FileInputStream("ggb.properties");
	    p.load(fis);
	    byte i = (byte)Integer.parseInt(p.getProperty("sequenceNo", "1"));
	    fis.close();
	    return i;
	} catch (IOException e) {
	    p.setProperty("sequenceNo", "1");
	    return 1;
	}
    }
    public static void saveSequenceNo(int i) {
	try {
	    FileOutputStream fos = new FileOutputStream("ggb.properties");
	    p.setProperty("sequenceNo", Integer.toString(i));
	    p.store(fos, "#Properties for BcastInject\n");
	} catch (IOException e) {
	    System.err.println("Exception while saving sequence number" +
			       e);
	    e.printStackTrace();
	}
    }

    public static void main(String[] argv) throws IOException {
	String cmd;
	byte sequenceNo = 0;
	boolean read_log = false;

	if (argv.length < 1) {
	    usage();
	    System.exit(-1);
	}

	cmd = argv[0];

	if (cmd.equals("start_sensing") && argv.length != 3) {
	    startSensingUsage();
	    System.exit(-1);
	} else if (cmd.equals("read_log") && argv.length != 2) {
	    readLogUsage();
	    System.exit(-1);
	} else if (cmd.equals("ping_node") && argv.length != 2) {
	    pingNodeUsage();
	    System.exit(-1);
	}
	
	SimpleCmdMsg packet = new SimpleCmdMsg(); 

	sequenceNo = restoreSequenceNo();
	packet.set_seqno(sequenceNo);
	packet.set_hop_count((short)0);
	packet.set_source(0);

	if (cmd.equals("led_on")) {
	    packet.set_action(LED_ON);
	} else if (cmd.equals("led_off")) {
	    packet.set_action(LED_OFF);
	} else if (cmd.equals("radio_louder")) {
	    packet.set_action(RADIO_LOUDER);
	} else if (cmd.equals("radio_quieter")) {
	    packet.set_action(RADIO_QUIETER);
	} else if (cmd.equals("start_sensing")) {
	    packet.set_action(START_SENSING);
	    nsamples = (short)Integer.parseInt(argv[1]);
	    interval = (long)Integer.parseInt(argv[2]);
	    packet.set_args_ss_args_nsamples((short)nsamples);
	    packet.set_args_ss_args_interval(interval);
		channel_selection[0] = true;
		channel_selection[1] = true;
		channel_selection[2] = false;
		channel_selection[3] = false;
	} else if (cmd.equals("read_log")) {
	    read_log = true;
	    packet.set_action(READ_LOG);
	    short address = (short)Integer.parseInt(argv[1]);
	    packet.set_args_rl_args_destaddr(address);
	} else if (cmd.equals("ping_node")) {
	    packet.set_action(PING_NODE);
	    short address = (short)Integer.parseInt(argv[1]);
	    packet.set_args_pn_args_destaddr(address);
	} else if (cmd.equals("find_node")) {
	    packet.set_action(FIND_NODE);
	} else if (cmd.equals("update_nodelist")) {
	} else {
	    usage();
	    System.exit(-1);
	}
        
	try {
	    System.err.print("Sending payload: ");
	  		
	    for (int i = 0; i < packet.dataLength(); i++) {
		System.err.print(Integer.toHexString(packet.dataGet()[i] & 0xff)+ " ");
	    }
	    System.err.println();

	    MoteIF mote = new MoteIF(PrintStreamMessenger.err);

	    // Need to wait for a read_log message to come back
	    BcastInject bc = null;
		if (cmd.equals("start_sensing")) {
			bc = new BcastInject();
			mote.registerListener(new OscopeMsg(), bc);
			mote.registerListener(new CtrlMsg(), bc);
			restore_nodelist();

			packet.set_args_ss_args_channel_selection((short)1);
			for (int i = 0; i < max_retry; i++) {
				mote.send(TOS_BCAST_ADDR, packet);
				synchronized (bc) { bc.wait(100); }
			}
			/* * * * * * * *
			 * Needs optimization                     ||||
			 */
			synchronized (bc) { bc.wait((int)(nsamples * interval * 0.0012 + 5000)); }
			packet.set_args_ss_args_channel_selection((short)0);
			for (int i = 0; i < max_retry; i++) {
				mote.send(TOS_BCAST_ADDR, packet);
				synchronized (bc) { bc.wait(100); }
			}
			synchronized (bc) { bc.wait(100); }
			
			packet.set_action(READ_LOG);
			for (int i = 0; i < last_mote_index; i++) {
			/* * * * * * * *
			 * Needs optimization
			 */
			 	if (mote_valid[i]) {
				 	open_files(i);
					packet.set_args_rl_args_destaddr(mote_num[i]);
					mote.send(mote_num[i], packet);
					synchronized (bc) { bc.wait(); }
					synchronized (bc) { bc.wait(100); }
					close_files();
				}
			}
			
			
		} else if (cmd.equals("read_log")) {
			bc = new BcastInject();
			mote.registerListener(new LogMsg(), bc);
	    
		    mote.send(TOS_BCAST_ADDR, packet);

			synchronized (bc) {
			    if (bc.read_log_done == false) {
				System.err.println("Waiting for response to read_log...");
				bc.wait(10000);
			    }
			    if (bc.read_log_done == false) {
				System.err.println("Warning: Timed out waiting for response to read_log command!");
				}
		    }
		} else if (cmd.equals("ping_node")) {
			bc = new BcastInject();
			mote.registerListener(new CtrlMsg(), bc);
			mote.send(TOS_BCAST_ADDR, packet);
			synchronized (bc) { bc.wait(round_trip); }
		} else if (cmd.equals("find_node")) {
			bc = new BcastInject();
			mote.registerListener(new CtrlMsg(), bc);
			mote.send(TOS_BCAST_ADDR, packet);
			synchronized (bc) { bc.wait(round_trip); }
		} else if (cmd.equals("update_nodelist")) {
			bc = new BcastInject();
			mote.registerListener(new CtrlMsg(), bc);
			
			packet.set_action(PING_NODE);
			restore_nodelist();
			for (int i = 0; i < last_mote_index; i++) {
				packet.set_args_pn_args_destaddr(mote_num[i]);
				reply_flag = false;
				mote.send(TOS_BCAST_ADDR, packet);
				synchronized (bc) { bc.wait(round_trip); }
				if (!reply_flag) {
					--num_mote;
					mote_valid[i] = false;
				}
			}
			
			packet.set_action(FIND_NODE);
			do {
				int j = 0;
				for (int i = 0; i < last_mote_index; i++) {
					if (mote_valid[i]) {
						packet.setElement_args_fn_args_nodes(j, mote_num[i]);
						++j;
					}
				}
				for (; j < 12; j++) {
					packet.setElement_args_fn_args_nodes(j, 0);
				}
				reply_flag = false;
				System.err.println("" + packet);
				mote.send(TOS_BCAST_ADDR, packet);
				synchronized (bc) { bc.wait(round_trip); }
			} while (reply_flag);

			save_nodelist();
		} else {
			mote.send(TOS_BCAST_ADDR, packet);
		}
		
	    saveSequenceNo(sequenceNo+1);
	    System.exit(0);

	} catch(Exception e) {
	    e.printStackTrace();
	}	

    }
    public void messageReceived(int dest_addr, Message m) {
	if (m instanceof LogMsg) {
		LogMsg lm = (LogMsg) m;
		System.err.println("Received log message: "+lm);

		System.err.print("Log values: ");
		for (int i = 0; i < lm.numElements_log(); i++) {
		    short val = lm.getElement_log(i);
		    System.err.print(Integer.toHexString((int)val)+" ");
		}
		System.err.println("");

		synchronized (this) {
		    read_log_done = true;
		    this.notifyAll();
		}
	} else if (m instanceof OscopeMsg) {
		OscopeMsg om = (OscopeMsg) m;
		int sourceMoteID = om.get_sourceMoteID();
		int lastSampleNumber = om.get_lastSampleNumber();
		int channel = om.get_channel();
		System.err.println("Received oscope message: "+om);
		System.err.println("sourceMoteID: " + sourceMoteID);
		System.err.println("lastSampleNumber: " + lastSampleNumber);
		System.err.println("channel: " + channel);
		System.err.print("Data values:");
		if (lastSampleNumber == 1) {
			pw[channel-1].println("sourceMoteID: " + sourceMoteID);
			pw[channel-1].println("channel: " + channel);
			pw[channel-1].println("start_time: " + start_time);
			pw[channel-1].println("finish_time: " + finish_time);
			pw[channel-1].println("nsamples: " + nsamples);
		}
		for (int i = 0; i < om.numElements_data(); i++) {
			int val = om.getElement_data(i);
			System.err.print(" "+val);
			pw[channel-1].println("" + val);
		}
		System.err.println("");
		if ((lastSampleNumber == (nsamples - 9))
			&& last_channel(channel)) {
			synchronized (this) { this.notifyAll(); }
		}
	} else if (m instanceof CtrlMsg) {
		CtrlMsg cm = (CtrlMsg) m;
		byte controlNumber = (byte)cm.get_controlNumber();
		if (controlNumber == TIME_REPORT) {
			start_time = cm.get_args_tr_args_start_time();
			finish_time = cm.get_args_tr_args_finish_time();
		} else if (controlNumber == PING_REPLY) {
			System.err.println("PING_REPLY");
			System.err.println("sourceMoteID: " + cm.get_sourceMoteID());
			System.err.println();
			reply_flag = true;
			synchronized (this) { this.notifyAll(); }
		} else if (controlNumber == FIND_REPLY) {
			System.err.println("FIND_REPLY");
			System.err.println("sourceMoteID: " + cm.get_sourceMoteID());
			System.err.println();
			mote_num[last_mote_index] = cm.get_sourceMoteID();
			mote_valid[last_mote_index] = true;;
			++last_mote_index;
			++num_mote;
			reply_flag = true;
			synchronized (this) { this.notifyAll(); }
		} else {
		}
	} else {
		System.err.println("# Got a packet of wrong format");
	}
    }
	private static void restore_nodelist() throws IOException {

	FileReader fr = new FileReader("nodelist");
	BufferedReader dr = new BufferedReader(fr);
	num_mote = Integer.parseInt(dr.readLine());
	last_mote_index = num_mote;
	//System.out.println("num_mote: " + num_mote);
	for (int i = 0; i < num_mote; i++) {
		mote_num[i] = Integer.parseInt(dr.readLine());
		mote_valid[i] = true;
		//System.out.println("mote_num[" + i + "]: " + mote_num[i]);
	}
	dr.close();
	fr.close();
	}
	private static void save_nodelist() throws IOException {
	FileOutputStream nl_fos = new FileOutputStream("nodelist");
	PrintWriter nl_pw = new PrintWriter(nl_fos);
	nl_pw.println("" + num_mote);
	System.err.println("last_mote_index: " + last_mote_index);
	System.err.println("num_mote: " + num_mote);
	for (int i = 0; i < last_mote_index; i++) {
		if (mote_valid[i]) {
			nl_pw.println("" + mote_num[i]);
		}
		System.err.print("mote_num[" + i + "]: " + mote_num[i] + "( ");
		System.err.println(mote_valid[i] + ")");
	}
	nl_pw.close();
	nl_fos.close();
	}
	private boolean last_channel(int channel_number) {
	int i = channel_number;
	for (;i < max_channel; i++) {
		if (channel_selection[i] == true) return false;
	}
	return true;
	}
	private static void open_files(int mote_index) throws IOException {
	for (int i = 0; i < max_channel; i++) {
		if (channel_selection[i]) {
			fos[i] = new FileOutputStream(restoreSequenceNo() + "_" +
				mote_num[mote_index] + "_" + i);
			pw[i] = new PrintWriter(fos[i]);
		}
	}
	}
	private static void close_files() throws IOException {
	for (int i = 0; i < max_channel; i++) {
		if (channel_selection[i]) {
			pw[i].close();
			fos[i].close();
		}
	}
	}

}

