/** * Copyright (c) 2003 - The Ohio State University. * All rights reserved. * * Permission to use, copy, modify, and distribute this software and its * documentation for any purpose, without fee, and without written agreement is * hereby granted, provided that the above copyright notice, the following * two paragraphs, and the author attribution appear in all copies of this * software. * * IN NO EVENT SHALL THE OHIO STATE UNIVERSITY BE LIABLE TO ANY PARTY FOR * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE OHIO STATE * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. * * THE OHIO STATE UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS * ON AN "AS IS" BASIS, AND THE OHIO STATE UNIVERSITY HAS NO OBLIGATION TO * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. */

/**
 * This class is automatically generated by mig. DO NOT EDIT THIS FILE.
 * This class implements a Java interface to the 'UpdateMsg'
 * message type.
 */

//package net.tinyos.RoutingDilVis;

public class UpdateMsg extends net.tinyos.message.Message {

    /** The default size of this message type in bytes. */
    public static final int DEFAULT_MESSAGE_SIZE = 27;

    /** The Active Message type associated with this message. */
    public static final int AM_TYPE = 32;

    /** Create a new UpdateMsg of size 27. */
    public UpdateMsg() {
        super(DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /** Create a new UpdateMsg of the given data_length. */
    public UpdateMsg(int data_length) {
        super(data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg with the given data_length
     * and base offset.
     */
    public UpdateMsg(int data_length, int base_offset) {
        super(data_length, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg using the given byte array
     * as backing store.
     */
    public UpdateMsg(byte[] data) {
        super(data);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg using the given byte array
     * as backing store, with the given base offset.
     */
    public UpdateMsg(byte[] data, int base_offset) {
        super(data, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg using the given byte array
     * as backing store, with the given base offset and data length.
     */
    public UpdateMsg(byte[] data, int base_offset, int data_length) {
        super(data, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg embedded in the given message
     * at the given base offset.
     */
    public UpdateMsg(net.tinyos.message.Message msg, int base_offset) {
        super(msg, base_offset, DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new UpdateMsg embedded in the given message
     * at the given base offset and length.
     */
    public UpdateMsg(net.tinyos.message.Message msg, int base_offset, int data_length) {
        super(msg, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
    /* Return a String representation of this message. Includes the
     * message type name and the non-indexed field values.
     */
    public String toString() {
      String s = "Message <UpdateMsg> \n";
      try {
        s += "  [type=0x"+Long.toHexString(get_type())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [state=0x"+Long.toHexString(get_state())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [path=";
        for (int i = 0; i < 25; i++) {
          s += "0x"+Long.toHexString(getElement_path(i) & 0xff)+" ";
        }
        s += "]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      return s;
    }

    // Message-type-specific access methods appear below.

    /////////////////////////////////////////////////////////
    // Accessor methods for field: type
    //   Field type: short, unsigned
    //   Offset (bits): 0
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'type' is signed (false).
     */
    public static boolean isSigned_type() {
        return false;
    }

    /**
     * Return whether the field 'type' is an array (false).
     */
    public static boolean isArray_type() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'type'
     */
    public static int offset_type() {
        return (0 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'type'
     */
    public static int offsetBits_type() {
        return 0;
    }

    /**
     * Return the value (as a short) of the field 'type'
     */
    public short get_type() {
        return (short)getUIntElement(offsetBits_type(), 8);
    }

    /**
     * Set the value of the field 'type'
     */
    public void set_type(short value) {
        setUIntElement(offsetBits_type(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'type'
     */
    public static int size_type() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'type'
     */
    public static int sizeBits_type() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: state
    //   Field type: byte, unsigned
    //   Offset (bits): 8
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'state' is signed (false).
     */
    public static boolean isSigned_state() {
        return false;
    }

    /**
     * Return whether the field 'state' is an array (false).
     */
    public static boolean isArray_state() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'state'
     */
    public static int offset_state() {
        return (8 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'state'
     */
    public static int offsetBits_state() {
        return 8;
    }

    /**
     * Return the value (as a byte) of the field 'state'
     */
    public byte get_state() {
        return (byte)getSIntElement(offsetBits_state(), 8);
    }

    /**
     * Set the value of the field 'state'
     */
    public void set_state(byte value) {
        setSIntElement(offsetBits_state(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'state'
     */
    public static int size_state() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'state'
     */
    public static int sizeBits_state() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: path
    //   Field type: short[], unsigned
    //   Offset (bits): 16
    //   Size of each element (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'path' is signed (false).
     */
    public static boolean isSigned_path() {
        return false;
    }

    /**
     * Return whether the field 'path' is an array (true).
     */
    public static boolean isArray_path() {
        return true;
    }

    /**
     * Return the offset (in bytes) of the field 'path'
     */
    public static int offset_path(int index1) {
        int offset = 16;
        if (index1 < 0 || index1 >= 25) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return (offset / 8);
    }

    /**
     * Return the offset (in bits) of the field 'path'
     */
    public static int offsetBits_path(int index1) {
        int offset = 16;
        if (index1 < 0 || index1 >= 25) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return offset;
    }

    /**
     * Return the entire array 'path' as a short[]
     */
    public short[] get_path() {
        short[] tmp = new short[25];
        for (int index0 = 0; index0 < numElements_path(0); index0++) {
            tmp[index0] = getElement_path(index0);
        }
        return tmp;
    }

    /**
     * Set the contents of the array 'path' from the given short[]
     */
    public void set_path(short[] value) {
        for (int index0 = 0; index0 < value.length; index0++) {
            setElement_path(index0, value[index0]);
        }
    }

    /**
     * Return an element (as a short) of the array 'path'
     */
    public short getElement_path(int index1) {
        return (short)getUIntElement(offsetBits_path(index1), 8);
    }

    /**
     * Set an element of the array 'path'
     */
    public void setElement_path(int index1, short value) {
        setUIntElement(offsetBits_path(index1), 8, value);
    }

    /**
     * Return the total size, in bytes, of the array 'path'
     */
    public static int totalSize_path() {
        return (200 / 8);
    }

    /**
     * Return the total size, in bits, of the array 'path'
     */
    public static int totalSizeBits_path() {
        return 200;
    }

    /**
     * Return the size, in bytes, of each element of the array 'path'
     */
    public static int elementSize_path() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of each element of the array 'path'
     */
    public static int elementSizeBits_path() {
        return 8;
    }

    /**
     * Return the number of dimensions in the array 'path'
     */
    public static int numDimensions_path() {
        return 1;
    }

    /**
     * Return the number of elements in the array 'path'
     */
    public static int numElements_path() {
        return 25;
    }

    /**
     * Return the number of elements in the array 'path'
     * for the given dimension.
     */
    public static int numElements_path(int dimension) {
      int array_dims[] = { 25,  };
        if (dimension < 0 || dimension >= 1) throw new ArrayIndexOutOfBoundsException();
        if (array_dims[dimension] == 0) throw new IllegalArgumentException("Array dimension "+dimension+" has unknown size");
        return array_dims[dimension];
    }

    /**
     * Fill in the array 'path' with a String
     */
    public void setString_path(String s) { 
         int len = s.length();
         int i;
         for (i = 0; i < len; i++) {
             setElement_path(i, (short)s.charAt(i));
         }
         setElement_path(i, (short)0); //null terminate
    }

    /**
     * Read the array 'path' as a String
     */
    public String getString_path() { 
         char carr[] = new char[Math.min(net.tinyos.message.Message.MAX_CONVERTED_STRING_LENGTH,25)];
         int i;
         for (i = 0; i < carr.length; i++) {
             if ((char)getElement_path(i) == (char)0) break;
             carr[i] = (char)getElement_path(i);
         }
         return new String(carr,0,i);
    }

}
