/*									tab:4
 *
 *
 * "Copyright (c) 2002 and The Regents of the University 
 * of California.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */

/**
 * File: RobotCmdGUI.java
 *
 * Description:
 * RobotCmdGUI provides a GUI interface to RobotCmd.  RobotCmd will send TinyOS
 * packets over the base station.  These commands are then re-packaged on the 
 * micamote and sent to the MotorBoard.
 *
 * @author written by Sarah Bergbreiter and mig-ified by Phoebus Chen
 * 
 * Created on August 10, 2002, 12:26 AM
 * Last Modified: 2/2/2003
 */

package RobotCmd;

import net.tinyos.util.*;
import net.tinyos.message.*;
import java.io.*;

public class RobotCmdGUI extends javax.swing.JFrame implements MessageListener {

    /*Constants for Commands or Reading-Types included in RC.java */

    /* Mote Communication Variable */
    private MoteIF mote;

    
    /** Creates new form RobotCmd */
    public RobotCmdGUI(int groupID) {
        initComponents();

        /* Set up mote communication */
        try {
	  mote = new MoteIF(PrintStreamMessenger.err, groupID);
	  mote.registerListener(new RobotCmdMsg(), this);
	  //mote.start();
	} catch(Exception e){
	  e.printStackTrace();
	  System.err.println("\t");
          System.err.println("\tSerialForwarder must be opened first!");
	  System.exit(-1);  //should this be a system exit?
	}
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        topPanel = new javax.swing.JPanel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        carControlPanel = new javax.swing.JPanel();
        speedPanel = new javax.swing.JPanel();
        speedSlider = new javax.swing.JSlider();
        spacerLabel1 = new javax.swing.JLabel();
        offButton = new javax.swing.JButton();
        spacerLabel11 = new javax.swing.JLabel();
        turnPanel = new javax.swing.JPanel();
        turnSlider = new javax.swing.JSlider();
        spacerLabel12 = new javax.swing.JLabel();
        straightButton = new javax.swing.JButton();
        spacerLabel13 = new javax.swing.JLabel();
        dirPanel = new javax.swing.JPanel();
        forwardButton = new javax.swing.JButton();
        reverseButton = new javax.swing.JButton();
        navPanel = new javax.swing.JPanel();
        navDirText = new javax.swing.JTextArea();
        navDataPanel = new javax.swing.JPanel();
        x1Label = new javax.swing.JLabel();
        x1Field = new javax.swing.JTextField();
        y1Label = new javax.swing.JLabel();
        y1Field = new javax.swing.JTextField();
        piNumLabel = new javax.swing.JLabel();
        piNumField = new javax.swing.JTextField();
        piDenLabel = new javax.swing.JLabel();
        piDenField = new javax.swing.JTextField();
        x2Label = new javax.swing.JLabel();
        x2Field = new javax.swing.JTextField();
        y2Label = new javax.swing.JLabel();
        y2Field = new javax.swing.JTextField();
        navigateButtonPanel = new javax.swing.JPanel();
        navigateButton = new javax.swing.JButton();
        figure8Panel = new javax.swing.JPanel();
        fig8CtlPanel = new javax.swing.JPanel();
        startFig8Button = new javax.swing.JButton();
        stopFig8Button = new javax.swing.JButton();
        fig8CalibPanel = new javax.swing.JPanel();
        fig8CalibButtonPanel = new javax.swing.JPanel();
        fig8SpeedButton = new javax.swing.JButton();
        fig8SpeedField = new javax.swing.JTextField();
        fig8Turn1Button = new javax.swing.JButton();
        fig8Turn1Field = new javax.swing.JTextField();
        fig8Turn2Button = new javax.swing.JButton();
        fig8Turn2Field = new javax.swing.JTextField();
        fig8Turn3Button = new javax.swing.JButton();
        fig8Turn3Field = new javax.swing.JTextField();
        fig8Turn4Button = new javax.swing.JButton();
        fig8Turn4Field = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        servoPanel = new javax.swing.JPanel();
        straightPanel = new javax.swing.JPanel();
        getStraightButton = new javax.swing.JButton();
        getStraightLabel = new javax.swing.JLabel();
        setStraightButton = new javax.swing.JButton();
        setStraightField = new javax.swing.JTextField();
        kPanel = new javax.swing.JPanel();
        getConstantsButton = new javax.swing.JButton();
        getConstantsField = new javax.swing.JLabel();
        setKpButton = new javax.swing.JButton();
        setKpField = new javax.swing.JTextField();
        setKiButton = new javax.swing.JButton();
        setKiField = new javax.swing.JTextField();
        speed2Panel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        turn2Slider = new javax.swing.JSlider();
        straight2Button = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        forward50Button = new javax.swing.JButton();
        reverse60Button = new javax.swing.JButton();
        off2Button = new javax.swing.JButton();
        otherPanel = new javax.swing.JPanel();
        ledPanel = new javax.swing.JPanel();
        micaLEDButton = new javax.swing.JButton();
        motorLEDButton = new javax.swing.JButton();
        motorTestPanel = new javax.swing.JPanel();
        startMotorTestButton = new javax.swing.JButton();
        stopMotorTestButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        msgArea = new javax.swing.JTextArea();
        navigationPanel1 = new NavigationPanel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

	setTitle("Robot Command GUI");

        topPanel.setLayout(new javax.swing.BoxLayout(topPanel, javax.swing.BoxLayout.X_AXIS));

        jTabbedPane1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        carControlPanel.setLayout(new java.awt.GridLayout(3, 1));

        carControlPanel.setToolTipText("Controlling the Robot Remotely");
        speedPanel.setLayout(new javax.swing.BoxLayout(speedPanel, javax.swing.BoxLayout.X_AXIS));

        speedPanel.setBorder(new javax.swing.border.TitledBorder("Speed (0-255)"));
        speedSlider.setMinorTickSpacing(10);
        speedSlider.setPaintLabels(true);
        speedSlider.setPaintTicks(true);
        speedSlider.setMajorTickSpacing(50);
        speedSlider.setMaximum(250);
        speedSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                speedSliderStateChanged(evt);
            }
        });

        speedSlider.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                speedSliderKeyReleased(evt);
            }
        });

        speedSlider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                speedSliderMouseReleased(evt);
            }
        });

        speedPanel.add(speedSlider);

        spacerLabel1.setText("        ");
        speedPanel.add(spacerLabel1);

        offButton.setText("OFF");
        offButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                offButtonActionPerformed(evt);
            }
        });

        speedPanel.add(offButton);

        spacerLabel11.setText("        ");
        speedPanel.add(spacerLabel11);

        carControlPanel.add(speedPanel);

        turnPanel.setLayout(new javax.swing.BoxLayout(turnPanel, javax.swing.BoxLayout.X_AXIS));

        turnPanel.setBorder(new javax.swing.border.TitledBorder("Turn (0-60, 30=straight)"));
        turnSlider.setMinorTickSpacing(5);
        turnSlider.setPaintLabels(true);
        turnSlider.setPaintTicks(true);
        turnSlider.setMajorTickSpacing(10);
        turnSlider.setMaximum(60);
        turnSlider.setValue(30);
        turnSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                turnSliderStateChanged(evt);
            }
        });

        turnSlider.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                turnSliderKeyReleased(evt);
            }
        });

        turnSlider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                turnSliderMouseReleased(evt);
            }
        });

        turnPanel.add(turnSlider);

        spacerLabel12.setText("        ");
        turnPanel.add(spacerLabel12);

        straightButton.setText("STRAIGHT");
        straightButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                straightButtonActionPerformed(evt);
            }
        });

        turnPanel.add(straightButton);

        spacerLabel13.setText("        ");
        turnPanel.add(spacerLabel13);

        carControlPanel.add(turnPanel);

        dirPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 30, 20));

        dirPanel.setBorder(new javax.swing.border.TitledBorder("Direction"));
        forwardButton.setText("FORWARD");
        forwardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                forwardButtonActionPerformed(evt);
            }
        });

        dirPanel.add(forwardButton);

        reverseButton.setText("REVERSE");
        reverseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reverseButtonActionPerformed(evt);
            }
        });

        dirPanel.add(reverseButton);

        carControlPanel.add(dirPanel);

        jTabbedPane1.addTab("Car Control", carControlPanel);

        navPanel.setLayout(new javax.swing.BoxLayout(navPanel, javax.swing.BoxLayout.Y_AXIS));

        navPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5)));
        navPanel.setToolTipText("Send Navigation Messages");
        navDirText.setLineWrap(true);
        navDirText.setText("Directions: \nEnter the robot's current location in cm in (x1,y1).\nEnter the robot's current heading as (Num*PI/Den).\nEnter the position the robot should navigate to in (x2,y2).");
        navDirText.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("Panel.background"));
        navPanel.add(navDirText);

        navDataPanel.setLayout(new java.awt.GridLayout(3, 4, 15, 10));

        navDataPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        x1Label.setText("    x1:");
        x1Label.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(x1Label);

        x1Field.setText("0");
        navDataPanel.add(x1Field);

        y1Label.setText("    y1:");
        y1Label.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(y1Label);

        y1Field.setText("0");
        navDataPanel.add(y1Field);

        piNumLabel.setText("Num:");
        piNumLabel.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(piNumLabel);

        piNumField.setText("1");
        navDataPanel.add(piNumField);

        piDenLabel.setText("Den:");
        piDenLabel.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(piDenLabel);

        piDenField.setText("2");
        navDataPanel.add(piDenField);

        x2Label.setText("    x2:");
        x2Label.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(x2Label);

        x2Field.setText("70");
        navDataPanel.add(x2Field);

        y2Label.setText("    y2:");
        y2Label.setFont(new java.awt.Font("Dialog", 1, 14));
        navDataPanel.add(y2Label);

        y2Field.setText("70");
        navDataPanel.add(y2Field);

        navPanel.add(navDataPanel);

        navigateButton.setText("Navigate!");
        navigateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                navigateButtonActionPerformed(evt);
            }
        });

        navigateButtonPanel.add(navigateButton);

        navPanel.add(navigateButtonPanel);

        navPanel.add(navigationPanel1);

        jTabbedPane1.addTab("Navigation", navPanel);

        figure8Panel.setLayout(new javax.swing.BoxLayout(figure8Panel, javax.swing.BoxLayout.Y_AXIS));

        figure8Panel.setToolTipText("Calibrate and use Figure8");
        fig8CtlPanel.setLayout(new javax.swing.BoxLayout(fig8CtlPanel, javax.swing.BoxLayout.X_AXIS));

        fig8CtlPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        startFig8Button.setText("Start Figure8");
        startFig8Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startFig8ButtonActionPerformed(evt);
            }
        });

        fig8CtlPanel.add(startFig8Button);

        stopFig8Button.setText("Stop Figure8");
        stopFig8Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopFig8ButtonActionPerformed(evt);
            }
        });

        fig8CtlPanel.add(stopFig8Button);

        figure8Panel.add(fig8CtlPanel);

        fig8CalibPanel.setLayout(new javax.swing.BoxLayout(fig8CalibPanel, javax.swing.BoxLayout.X_AXIS));

        fig8CalibPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        fig8CalibButtonPanel.setLayout(new java.awt.GridLayout(5, 2, 10, 10));

        fig8CalibButtonPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        fig8SpeedButton.setText("Speed");
        fig8SpeedButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fig8SpeedButtonActionPerformed(evt);
            }
        });

        fig8CalibButtonPanel.add(fig8SpeedButton);

        fig8SpeedField.setText("80");
        fig8CalibButtonPanel.add(fig8SpeedField);

        fig8Turn1Button.setText("Right");
        fig8Turn1Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fig8Turn1ButtonActionPerformed(evt);
            }
        });

        fig8CalibButtonPanel.add(fig8Turn1Button);

        fig8Turn1Field.setText("3");
        fig8CalibButtonPanel.add(fig8Turn1Field);

        fig8Turn2Button.setText("Straight1");
        fig8Turn2Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fig8Turn2ButtonActionPerformed(evt);
            }
        });

        fig8CalibButtonPanel.add(fig8Turn2Button);

        fig8Turn2Field.setText("13");
        fig8CalibButtonPanel.add(fig8Turn2Field);

        fig8Turn3Button.setText("Left");
        fig8Turn3Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fig8Turn3ButtonActionPerformed(evt);
            }
        });

        fig8CalibButtonPanel.add(fig8Turn3Button);

        fig8Turn3Field.setText("16");
        fig8CalibButtonPanel.add(fig8Turn3Field);

        fig8Turn4Button.setText("Straight2");
        fig8Turn4Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fig8Turn4ButtonActionPerformed(evt);
            }
        });

        fig8CalibButtonPanel.add(fig8Turn4Button);

        fig8Turn4Field.setText("28");
        fig8CalibButtonPanel.add(fig8Turn4Field);

        fig8CalibPanel.add(fig8CalibButtonPanel);

        jLabel1.setIcon(new javax.swing.ImageIcon("D:\\Photos\\From My Pictures\\Figure8-2.gif"));
        fig8CalibPanel.add(jLabel1);

        figure8Panel.add(fig8CalibPanel);

        jTabbedPane1.addTab("Figure8", figure8Panel);

        servoPanel.setLayout(new javax.swing.BoxLayout(servoPanel, javax.swing.BoxLayout.Y_AXIS));

        servoPanel.setToolTipText("Calibrate the Mini-Z Servo");
        straightPanel.setLayout(new java.awt.GridLayout(2, 2, 20, 5));

        straightPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(20, 20, 20, 20)));
        getStraightButton.setText("Get Straight");
        getStraightButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getStraightButtonActionPerformed(evt);
            }
        });

        straightPanel.add(getStraightButton);

        straightPanel.add(getStraightLabel);

        setStraightButton.setText("Set Straight");
        setStraightButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setStraightButtonActionPerformed(evt);
            }
        });

        straightPanel.add(setStraightButton);

        straightPanel.add(setStraightField);

        servoPanel.add(straightPanel);

        kPanel.setLayout(new java.awt.GridLayout(3, 2, 20, 5));

        kPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        getConstantsButton.setText("Get Kp and Ki Constants");
        getConstantsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getConstantsButtonActionPerformed(evt);
            }
        });

        kPanel.add(getConstantsButton);

        kPanel.add(getConstantsField);

        setKpButton.setText("Set Kp");
        setKpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setKpButtonActionPerformed(evt);
            }
        });

        kPanel.add(setKpButton);

        kPanel.add(setKpField);

        setKiButton.setText("Set Ki");
        setKiButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setKiButtonActionPerformed(evt);
            }
        });

        kPanel.add(setKiButton);

        kPanel.add(setKiField);

        servoPanel.add(kPanel);

        speed2Panel.setLayout(new javax.swing.BoxLayout(speed2Panel, javax.swing.BoxLayout.Y_AXIS));

        turn2Slider.setMinorTickSpacing(5);
        turn2Slider.setPaintLabels(true);
        turn2Slider.setPaintTicks(true);
        turn2Slider.setMajorTickSpacing(10);
        turn2Slider.setMaximum(60);
        turn2Slider.setValue(30);
        turn2Slider.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                turn2SliderKeyReleased(evt);
            }
        });

        turn2Slider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                turn2SliderMouseReleased(evt);
            }
        });

        jPanel1.add(turn2Slider);

        straight2Button.setText("STRAIGHT");
        straight2Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                straight2ButtonActionPerformed(evt);
            }
        });

        jPanel1.add(straight2Button);

        speed2Panel.add(jPanel1);

        forward50Button.setText("FORWARD (50)");
        forward50Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                forward50ButtonActionPerformed(evt);
            }
        });

        jPanel2.add(forward50Button);

        reverse60Button.setText("REVERSE (60)");
        reverse60Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reverse60ButtonActionPerformed(evt);
            }
        });

        jPanel2.add(reverse60Button);

        off2Button.setText("OFF");
        off2Button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                off2ButtonActionPerformed(evt);
            }
        });

        jPanel2.add(off2Button);

        speed2Panel.add(jPanel2);

        servoPanel.add(speed2Panel);

        jTabbedPane1.addTab("Servo Calibration", servoPanel);

        otherPanel.setLayout(new java.awt.BorderLayout());

        micaLEDButton.setText("Toggle MICA LED");
        micaLEDButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                micaLEDButtonActionPerformed(evt);
            }
        });

        ledPanel.add(micaLEDButton);

        motorLEDButton.setText("Toggle MotorBoard LED");
        motorLEDButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                motorLEDButtonActionPerformed(evt);
            }
        });

        ledPanel.add(motorLEDButton);

        otherPanel.add(ledPanel, java.awt.BorderLayout.CENTER);

        startMotorTestButton.setText("Start Motor Test");
        startMotorTestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startMotorTestButtonActionPerformed(evt);
            }
        });

        motorTestPanel.add(startMotorTestButton);

        stopMotorTestButton.setText("Stop Motor Test");
        stopMotorTestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopMotorTestButtonActionPerformed(evt);
            }
        });

        motorTestPanel.add(stopMotorTestButton);

        otherPanel.add(motorTestPanel, java.awt.BorderLayout.NORTH);

        jTabbedPane1.addTab("Other", otherPanel);

        topPanel.add(jTabbedPane1);

        jScrollPane1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(30, 10, 10, 10)));
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("ScrollPane.background"));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 0));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(250, 0));
        jScrollPane1.setAutoscrolls(true);
        msgArea.setPreferredSize(null);
        msgArea.setMinimumSize(null);
        jScrollPane1.setViewportView(msgArea);

        topPanel.add(jScrollPane1);

        getContentPane().add(topPanel, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void turnSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_turnSliderStateChanged
        // Add your handling code here:
    }//GEN-LAST:event_turnSliderStateChanged

    private void speedSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_speedSliderStateChanged
        // Add your handling code here:
    }//GEN-LAST:event_speedSliderStateChanged

    private void getConstantsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_getConstantsButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.GET_KP, data);
        try {
            Thread.sleep(200);
	} catch(InterruptedException e){
	  e.printStackTrace();
	}
        sendMsg(RC.GET_KI, data);
    }//GEN-LAST:event_getConstantsButtonActionPerformed

    private void getStraightButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_getStraightButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.GET_STRAIGHT, data);
    }//GEN-LAST:event_getStraightButtonActionPerformed

    private void motorLEDButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_motorLEDButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.LED_TOGGLE, data);
    }//GEN-LAST:event_motorLEDButtonActionPerformed

    private void micaLEDButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_micaLEDButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.MICA_LED_TOGGLE, data);
    }//GEN-LAST:event_micaLEDButtonActionPerformed

    private void stopMotorTestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopMotorTestButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.MOTOR_TEST_STOP, data);
    }//GEN-LAST:event_stopMotorTestButtonActionPerformed

    private void startMotorTestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startMotorTestButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.MOTOR_TEST_START, data);
    }//GEN-LAST:event_startMotorTestButtonActionPerformed

    private void off2ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_off2ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {RC.OFF};
        sendMsg(RC.SET_SPEED, data);
    }//GEN-LAST:event_off2ButtonActionPerformed

    private void reverse60ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reverse60ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {60,(byte)turn2Slider.getValue()};
        sendMsg(RC.SET_SPEEDTURNDIR, data);
    }//GEN-LAST:event_reverse60ButtonActionPerformed

    private void forward50ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_forward50ButtonActionPerformed
        // Add your handling code here:
        byte turn = (byte)turn2Slider.getValue();
        byte data[] = {50,(byte)(turn | 0x80)};
        sendMsg(RC.SET_SPEEDTURNDIR, data);
    }//GEN-LAST:event_forward50ButtonActionPerformed

    private void turn2SliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_turn2SliderMouseReleased
        // Add your handling code here:
        byte data[] = {(byte)turn2Slider.getValue()};
        sendMsg(RC.SET_TURN, data);
    }//GEN-LAST:event_turn2SliderMouseReleased

    private void turn2SliderKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_turn2SliderKeyReleased
        // Add your handling code here:
        if ((evt.getKeyCode() == java.awt.event.KeyEvent.VK_LEFT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_RIGHT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_UP) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_DOWN)) {
                byte data[] = {(byte)turn2Slider.getValue()};
                sendMsg(RC.SET_TURN, data);
        }
    }//GEN-LAST:event_turn2SliderKeyReleased

    private void straight2ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_straight2ButtonActionPerformed
        // Add your handling code here:
        turn2Slider.setValue(RC.STRAIGHT);
        byte data[] = {RC.STRAIGHT};
        sendMsg(RC.SET_TURN, data);
    }//GEN-LAST:event_straight2ButtonActionPerformed

    private void setKiButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setKiButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(setKiField.getText())};
        sendMsg(RC.SET_KI, data);
    }//GEN-LAST:event_setKiButtonActionPerformed

    private void setKpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setKpButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(setKpField.getText())};
        sendMsg(RC.SET_KP, data);
    }//GEN-LAST:event_setKpButtonActionPerformed

    private void setStraightButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setStraightButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(setStraightField.getText())};
        sendMsg(RC.SET_STRAIGHT, data);
    }//GEN-LAST:event_setStraightButtonActionPerformed

    private void fig8Turn4ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fig8Turn4ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(fig8Turn3Field.getText()), (byte)Integer.parseInt(fig8Turn4Field.getText())};
        sendMsg(RC.SET_TURN34, data);
    }//GEN-LAST:event_fig8Turn4ButtonActionPerformed

    private void fig8Turn3ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fig8Turn3ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(fig8Turn3Field.getText()), (byte)Integer.parseInt(fig8Turn4Field.getText())};
        sendMsg(RC.SET_TURN34, data);
    }//GEN-LAST:event_fig8Turn3ButtonActionPerformed

    private void fig8Turn2ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fig8Turn2ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(fig8Turn1Field.getText()), (byte)Integer.parseInt(fig8Turn2Field.getText())};
        sendMsg(RC.SET_TURN12, data);
    }//GEN-LAST:event_fig8Turn2ButtonActionPerformed

    private void fig8Turn1ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fig8Turn1ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)Integer.parseInt(fig8Turn1Field.getText()), (byte)Integer.parseInt(fig8Turn2Field.getText())};
        sendMsg(RC.SET_TURN12, data);
    }//GEN-LAST:event_fig8Turn1ButtonActionPerformed

    private void fig8SpeedButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fig8SpeedButtonActionPerformed
        // Add your handling code here:
        byte data[] = {(byte)(Integer.parseInt(x1Field.getText()))};
        sendMsg(RC.SET_FIGURE8_SPEED, data);
    }//GEN-LAST:event_fig8SpeedButtonActionPerformed

    private void stopFig8ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopFig8ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.STOP_FIGURE8, data);
    }//GEN-LAST:event_stopFig8ButtonActionPerformed

    private void startFig8ButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startFig8ButtonActionPerformed
        // Add your handling code here:
        byte data[] = {};
        sendMsg(RC.START_FIGURE8, data);
    }//GEN-LAST:event_startFig8ButtonActionPerformed

    private void turnSliderKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_turnSliderKeyReleased
        // Add your handling code here:
        if ((evt.getKeyCode() == java.awt.event.KeyEvent.VK_LEFT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_RIGHT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_UP) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_DOWN)) {
                byte data[] = {(byte)turnSlider.getValue()};
                sendMsg(RC.SET_TURN, data);
        }
    }//GEN-LAST:event_turnSliderKeyReleased

    private void speedSliderKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_speedSliderKeyReleased
        // Add your handling code here:
        if ((evt.getKeyCode() == java.awt.event.KeyEvent.VK_LEFT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_RIGHT) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_UP) ||
            (evt.getKeyCode() == java.awt.event.KeyEvent.VK_DOWN)) {
                byte data[] = {(byte)speedSlider.getValue()};
                sendMsg(RC.SET_SPEED, data);
        }
    }//GEN-LAST:event_speedSliderKeyReleased

    private void turnSliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_turnSliderMouseReleased
        // Add your handling code here:
        byte data[] = {(byte)turnSlider.getValue()};
        sendMsg(RC.SET_TURN, data);
    }//GEN-LAST:event_turnSliderMouseReleased

    private void speedSliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_speedSliderMouseReleased
        // Add your handling code here:
        byte data[] = {(byte)speedSlider.getValue()};
        sendMsg(RC.SET_SPEED, data);
    }//GEN-LAST:event_speedSliderMouseReleased

    private void reverseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reverseButtonActionPerformed
        // Add your handling code here:
        byte data[] = {RC.REVERSE};
        sendMsg(RC.SET_DIRECTION, data);
    }//GEN-LAST:event_reverseButtonActionPerformed

    private void forwardButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_forwardButtonActionPerformed
        // Add your handling code here:
        byte data[] = {RC.FORWARD};
        sendMsg(RC.SET_DIRECTION, data);
    }//GEN-LAST:event_forwardButtonActionPerformed

    private void straightButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_straightButtonActionPerformed
        // Add your handling code here:
        turnSlider.setValue(RC.STRAIGHT);
        byte data[] = {RC.STRAIGHT};
        sendMsg(RC.SET_TURN, data);
    }//GEN-LAST:event_straightButtonActionPerformed

    private void offButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_offButtonActionPerformed
        // Add your handling code here:
        speedSlider.setValue(RC.OFF);
        byte data[] = {RC.OFF};
        sendMsg(RC.SET_SPEED, data);
    }//GEN-LAST:event_offButtonActionPerformed

    private void navigateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_navigateButtonActionPerformed
        // Add your handling code here:
        int x1 = Integer.parseInt(x1Field.getText());
        int y1 = Integer.parseInt(y1Field.getText());
        int piNum = Integer.parseInt(piNumField.getText());
        int piDen = Integer.parseInt(piDenField.getText());
        int x2 = Integer.parseInt(x2Field.getText());
        int y2 = Integer.parseInt(y2Field.getText());
        if (piDen == 0) return;
        navigationPanel1.navigate(x1,y1,piNum*Math.PI/piDen,x2,y2);
        
        NavigationMsg navMsg = new NavigationMsg();
        navMsg.set_x1((short)x1);
        navMsg.set_y1((short)y1);
        navMsg.set_x2((short)x2);
        navMsg.set_y2((short)y2);
        navMsg.set_PiNumerator((byte)piNum);
        navMsg.set_PiDenominator((byte)piDen);
        try { //devNote: should I catch this???
            mote.send(MoteIF.TOS_BCAST_ADDR, navMsg); //Controls all robots
        } catch (IOException e) {
            System.err.println("Unable to write to SerialForwarderStub");
            System.exit(-1);
        }
        msgArea.append(navMsg.toString() + "\n");
    }//GEN-LAST:event_navigateButtonActionPerformed

    private void sendMsg(short command, byte[] data) {
	RobotCmdMsg cmdMsg = new RobotCmdMsg();
        cmdMsg.set_type(command);
        for (int i = 0; i < data.length; i++)
            cmdMsg.setElement_data(i,data[i]);

        try { 
	    mote.send(MoteIF.TOS_BCAST_ADDR, cmdMsg); //Controls all robots
        } catch (IOException e) {
            System.err.println("Unable to write to SerialForwarderStub");
            System.exit(-1);
        }
	//devNote: how to add moteID + groupID???
	msgArea.append(cmdMsg.toString() + "\n");
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    

    /** Usage message */
    private void usage() {
        System.err.println("Usage: java RobotCmd.RobotCmdGUI"+
			       " <groupID>");
        System.err.println("\twhere [groupID] is the mote group ID in decimal format.");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        int groupID = 125;
        if (args.length == 1) {
	    groupID = Integer.parseInt(args[0]);
	} /* Add usage information here -- or could add command line stuff instead of doing GUI */
	System.err.println("RobotCmdGUI: Using group ID "+groupID);

        new RobotCmdGUI(groupID).show();
    }
    

    /**  messageReceived will fire when a packet has been received by the SerialForwarder. */
    public void messageReceived(int destAddr, Message msg) {
        if (msg instanceof RobotCmdMsg) {
            robotCmdReceived(destAddr, (RobotCmdMsg)msg);
        }
	//if (msg instanceof RobotCmdMsg) {
	//    robotReceived( dest_addr, (RobotCmdMsg)msg); }
	/*FOR FUTURE ADDITIONS
	   else if (msg instanceof otherMsg) {
	   otherReceived(dest_addr, (otherMsg)msg);
	} else {
	  throw new RuntimeException("messageReceived: Got bad message type: "+msg);
	} */
    }

    private void robotCmdReceived(int destAddr, RobotCmdMsg msg) {
	byte type = (byte) msg.get_type();
        if (type == RC.GET_STRAIGHT)
            setStraightField.setText(String.valueOf(msg.getElement_data(0)));
        else if (type == RC.GET_KP)
            setKpField.setText(String.valueOf(msg.getElement_data(0)));
        else if (type == RC.GET_KI)
            setKiField.setText(String.valueOf(msg.getElement_data(0)));
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel dirPanel;
    private javax.swing.JPanel carControlPanel;
    private javax.swing.JTextField piNumField;
    private javax.swing.JPanel servoPanel;
    private javax.swing.JTextField fig8Turn3Field;
    private javax.swing.JPanel fig8CtlPanel;
    private javax.swing.JPanel kPanel;
    private javax.swing.JLabel spacerLabel1;
    private javax.swing.JPanel topPanel;
    private javax.swing.JButton forward50Button;
    private javax.swing.JPanel speed2Panel;
    private javax.swing.JLabel piNumLabel;
    private javax.swing.JLabel getConstantsField;
    private javax.swing.JButton fig8Turn3Button;
    private javax.swing.JButton forwardButton;
    private javax.swing.JButton straight2Button;
    private javax.swing.JTextField y2Field;
    private javax.swing.JButton setKiButton;
    private javax.swing.JPanel navPanel;
    private javax.swing.JButton offButton;
    private javax.swing.JLabel y2Label;
    private javax.swing.JSlider speedSlider;
    private javax.swing.JButton reverseButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton setKpButton;
    private javax.swing.JTextArea msgArea;
    private javax.swing.JTextField fig8Turn2Field;
    private javax.swing.JPanel turnPanel;
    private javax.swing.JTextField setKpField;
    private javax.swing.JTextArea navDirText;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton off2Button;
    private javax.swing.JButton stopFig8Button;
    private javax.swing.JPanel otherPanel;
    private javax.swing.JButton fig8Turn2Button;
    private javax.swing.JTextField y1Field;
    private javax.swing.JTextField x2Field;
    private javax.swing.JTextField setKiField;
    private javax.swing.JTextField fig8SpeedField;
    private javax.swing.JPanel ledPanel;
    private javax.swing.JPanel navigateButtonPanel;
    private javax.swing.JLabel y1Label;
    private javax.swing.JTextField setStraightField;
    private javax.swing.JLabel x2Label;
    private javax.swing.JPanel motorTestPanel;
    private javax.swing.JButton setStraightButton;
    private javax.swing.JPanel fig8CalibButtonPanel;
    private javax.swing.JButton motorLEDButton;
    private javax.swing.JButton fig8Turn1Button;
    private javax.swing.JButton startFig8Button;
    private javax.swing.JPanel speedPanel;
    private javax.swing.JButton reverse60Button;
    private javax.swing.JTextField fig8Turn1Field;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel fig8CalibPanel;
    private javax.swing.JButton getConstantsButton;
    private javax.swing.JPanel navDataPanel;
    private javax.swing.JButton stopMotorTestButton;
    private javax.swing.JTextField fig8Turn4Field;
    private javax.swing.JLabel spacerLabel13;
    private javax.swing.JLabel spacerLabel12;
    private javax.swing.JPanel figure8Panel;
    private javax.swing.JLabel spacerLabel11;
    private javax.swing.JTextField x1Field;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JSlider turn2Slider;
    private javax.swing.JButton navigateButton;
    private javax.swing.JButton fig8Turn4Button;
    private javax.swing.JSlider turnSlider;
    private javax.swing.JLabel x1Label;
    private javax.swing.JButton getStraightButton;
    private javax.swing.JButton straightButton;
    private javax.swing.JTextField piDenField;
    private javax.swing.JButton fig8SpeedButton;
    private javax.swing.JButton startMotorTestButton;
    private javax.swing.JPanel straightPanel;
    private javax.swing.JButton micaLEDButton;
    private javax.swing.JLabel getStraightLabel;
    private javax.swing.JLabel piDenLabel;
    private NavigationPanel navigationPanel1;
    // End of variables declaration//GEN-END:variables
    
}
