package net.tinyos.surge.PacketAnalyzer;

import net.tinyos.surge.*;
import net.tinyos.surge.event.*;
import net.tinyos.message.*;
import net.tinyos.surge.util.*;
import java.util.*;
import java.lang.*;
import java.text.*;
import javax.swing.*;
import net.tinyos.surge.Dialog.*;
import java.awt.*;
import net.tinyos.surge.messages.*;

public class DelugeAnalyzer extends PacketAnalyzer
{
  protected static Hashtable proprietaryNodeInfo;
  protected static TwoKeyHashtable proprietaryEdgeInfo;

  private int maxVersion;
  private int maxRunningVersion;
  private long delugeStarted;
  private long delugeStopped;

  public DelugeAnalyzer() {
    super();
    if(MainClass.getMoteIF() != null) 
      MainClass.getMoteIF().registerListener(new DelugeReportingMsg(), this);

    proprietaryNodeInfo = new Hashtable();
    proprietaryEdgeInfo = new TwoKeyHashtable();

    MainClass.objectMaintainer.AddEdgeEventListener(this);
    MainClass.objectMaintainer.AddNodeEventListener(this);
    AnalyzerDisplayEnable();
    
    new Thread(new DecayThread()).start();
  }

  public void messageReceived(int addr, Message m) {
    if(m.amType() == DelugeReportingMsg.AM_TYPE){
      MultihopMsg msg = new MultihopMsg(m.dataGet());
      this.PacketReceived(msg);
    }
  }
  
  public void PacketReceived(MultihopMsg msg) {
    Integer currentNodeNumber = new Integer(msg.get_originaddr());
    NodeInfo currentNodeInfo;   
    if( (currentNodeInfo = (NodeInfo)proprietaryNodeInfo.get(currentNodeNumber)) != null) {
      currentNodeInfo.update(msg);
    }
  }

  public synchronized void NodeCreated(NodeEvent e) {
    Integer newNodeNumber = e.GetNodeNumber();
    proprietaryNodeInfo.put(newNodeNumber, new NodeInfo(newNodeNumber));
  }
  
  public synchronized void NodeDeleted(NodeEvent e) {
    Integer deletedNodeNumber = e.GetNodeNumber();
    proprietaryNodeInfo.remove(deletedNodeNumber);
  }

  public void PaintScreenBefore(Graphics g) {
    Dimension d = MainClass.mainFrame.GetGraphDisplayPanel().getSize();

    g.setColor(Color.red);
    g.setFont(new Font("Helvetica", Font.PLAIN, 24));

    long curtime = System.currentTimeMillis();

    NodeInfo nodeInfo;
    int versionNodes = 0, runningVersionNodes = 0, completeNodes = 0, totalNodes = 0;
    int totalPages = 0, completePages = 0;
    for(Enumeration nodes = proprietaryNodeInfo.elements();
	nodes.hasMoreElements();) {
      
      nodeInfo = (NodeInfo) nodes.nextElement();
      
      totalNodes++;

      if (nodeInfo.versionNumber != 0) {
	if (nodeInfo.runningVersionNumber == nodeInfo.versionNumber) {
	  runningVersionNodes++;
	} else {
	  versionNodes++;
	}
      }

      if (nodeInfo.numPages == nodeInfo.numPagesComplete) {
	completeNodes++;
      } else {
	completePages += nodeInfo.numPagesComplete;
	totalPages += nodeInfo.numPages;
      }

      if (nodeInfo.versionNumber == maxVersion) {
	completePages += nodeInfo.numPagesComplete;
	totalPages += nodeInfo.numPages;
      }
    }

    if (totalNodes > 0) {
      g.drawString("Nodes:" + totalNodes,
		   10,24);

      g.drawString("Downloading:" + 
		   (int)((double)versionNodes/totalNodes*100.0) + "%",
		   140,24);

      g.drawString("Packets:" + 
		   (int)((double)completePages/totalPages*100.0) + "%",
		   360,24);

      g.drawString("Complete:" + 
		   (int)((double)completeNodes/totalNodes*100.0) + "%",
		   530,24);
      
      g.drawString("Rebooted:" + 
		   (int)((double)runningVersionNodes/totalNodes*100.0) + "%",
		   740,24);
      
      if (completeNodes == totalNodes && delugeStopped == 0) {
	delugeStopped = curtime;
      }

      long minutes = 0, seconds = 0;

      if (delugeStopped == 0 && delugeStarted != 0) {
	minutes = (curtime - delugeStarted) / 1000 / 60;
	seconds = (curtime - delugeStarted) / 1000 % 60;
      } else if (delugeStopped != 0 && delugeStarted != 0) {
	minutes = (delugeStopped - delugeStarted) / 1000 / 60;
	seconds = (delugeStopped - delugeStarted) / 1000 % 60;
      } else {
	minutes = 0; seconds = 0;
      }

      if (seconds < 10) {
	g.drawString("" + minutes + ":0" + seconds, 10, 48);
      } else {
	g.drawString("" + minutes + ":" + seconds, 10, 48);
      }

    } else {
      g.drawString("No Data",
		   10,24);
    }    
  }

  public void PaintNode(Integer pNodeNumber, 
			int x1, int y1, int x2, int y2, Graphics g) {
      NodeInfo nodeInfo = (NodeInfo)proprietaryNodeInfo.get(pNodeNumber);
      if(nodeInfo==null) return;
      
      long curtime = System.currentTimeMillis();
      double ageAlpha = (double) 1 - ((curtime - nodeInfo.lastTime) / 
	(double) ObjectMaintainer.nodeExpireTime);
      int ageAlphaInt = (int) (ageAlpha * 255);

//      System.out.println("age: " + (curtime - nodeInfo.lastTime) + " max:" + ObjectMaintainer.nodeExpireTime);

      if (ageAlpha < 0.50) {
	ageAlphaInt = 128;
      }

      g.setColor(Color.black);
      g.fillOval(x1, y1, x2-x1, y2-y1);
      g.setColor(new Color(255,255,255,ageAlphaInt));
      g.drawOval(x1, y1, x2-x1, y2-y1);

      if (nodeInfo.active) {
	g.setColor(new Color(255,0,0,ageAlphaInt));
	g.drawOval(x1, y1, x2-x1, y2-y1);
//	g.drawOval(x1+3, y1+3, x2-x1-6, y2-y1-6);
      }
      
      if (nodeInfo.versionNumber == nodeInfo.runningVersionNumber &&
	  nodeInfo.versionNumber != 0) {
	g.setColor(new Color(0,255,0,ageAlphaInt));
	g.drawOval(x1-3, y1-3, x2-x1+6, y2-y1+6);
      } else {
	if (nodeInfo.numPagesComplete == nodeInfo.numPages) {
	  g.setColor(new Color(0,255,255,ageAlphaInt));
	} else {
	  g.setColor(new Color(255,0,0,ageAlphaInt));
	}
	g.fillArc(x1, y1, x2-x1, y2-y1, 90, (int)(-360.0*((double)nodeInfo.numPagesComplete / (double) nodeInfo.numPages))); 
      }

      g.setColor(MainFrame.labelColor);
      g.setFont(MainFrame.bigFont);
      String s = nodeInfo.getInfoString();
      g.drawString(s, (x1+x2)/2, y2-(y2-y1)/4 + 20);
  }

  private class NodeInfo
  {
    public Integer nodeNumber;
    public boolean active;
    public boolean goodRound;

    public int msgCount;
    public int lastSeqNo;

    public long lastTime;
    public long lastGoodTime;

    public int runningVersionNumber;

    public int versionNumber;
    public int numPages;
    public int numPagesComplete;

    private int SAMPLE_PERIOD = 4096;

    public NodeInfo(Integer nodeNum) {
      nodeNumber = nodeNum;
      msgCount = 0;
    }

    public void update(MultihopMsg msg) {
      DelugeReportingMsg sMsg = new DelugeReportingMsg(msg.dataGet(), msg.offset_data(0));
      
      System.out.println("--------- Node " + msg.get_originaddr() + " ----------");     
      System.out.println(sMsg);
      
      long curtime = System.currentTimeMillis();

      active = true;
      lastTime = curtime;

      msgCount++;
      runningVersionNumber = sMsg.get_runningVNum();

      versionNumber = sMsg.get_vNum();
      numPages = sMsg.get_numPages();
      numPagesComplete = sMsg.get_numPagesComplete();

      if (versionNumber > maxVersion) {
	if (maxVersion != 0) {
	  delugeStarted = curtime;
	  delugeStopped = 0;
	}
	maxVersion = versionNumber;
      }

      if (versionNumber > maxRunningVersion)
	maxRunningVersion = runningVersionNumber;

/*
      lastSeqNo = (int)sMsg.get_seq_no();

      if (sMsg.get_goodRound() == 1) {
	goodRound = true;
	lastGoodTime = curtime;
      } else {
	goodRound = false;
      }
*/
    }

    public void decay() {

      long curtime = System.currentTimeMillis();

      if (goodRound && 
	  (curtime-lastGoodTime >= (SAMPLE_PERIOD*2)))
      { goodRound = false; }
      
      if (active && 
	  (curtime-lastTime >= (SAMPLE_PERIOD/4))) 
      { active = false; }
    }

    public String getInfoString() { 
//      return "" + msgCount + " msgs";
      return "V:" + versionNumber;
    }
  }

  private class DecayThread extends Thread 
  {
    private int DECAY_THREAD_RATE = 512;

    public void run() {
      while (true) {
	try {
	  Thread.currentThread().sleep(DECAY_THREAD_RATE);
	  Enumeration e = proprietaryNodeInfo.elements();
	  while (e.hasMoreElements()) {
	    NodeInfo ni = (NodeInfo)e.nextElement();
	    ni.decay();
	  }
	} catch (Exception e) { /* Ignore */ } 
      }
    }
  }
}
