/** 
 * Get photo-sensor data and transmit it over radio.
 * - Revision -------------------------------------------------------------
 * $Revision$
 * $Date$
 * @author: Jan Hauer (hauer@tkn.tu-berlin.de)
 * ========================================================================
 */
configuration SenseToRfmIFX {
}
implementation {
  components Main, LedsC, TDA5250RadioC, SenseToRfmIFXM, MSP430ADC12C, TimerC,
               RefVoltC; 

  Main.StdControl -> SenseToRfmIFXM;
  Main.StdControl -> TDA5250RadioC;
  Main.StdControl -> TimerC;
  Main.StdControl -> MSP430ADC12C;

  SenseToRfmIFXM.ADC -> MSP430ADC12C.MSP430ADC12External[unique("MSP430ADC12External")];
  SenseToRfmIFXM.Leds -> LedsC;
  SenseToRfmIFXM.TimeoutTimer -> TimerC.TimerJiffy[unique("TimerJiffy")];
  
  SenseToRfmIFXM.RadioControl -> TDA5250RadioC;
  SenseToRfmIFXM.BareSendMsg -> TDA5250RadioC;
  SenseToRfmIFXM.ReceiveMsg -> TDA5250RadioC;
  SenseToRfmIFXM.RefVolt -> RefVoltC;
}

