// testing the ADC. confusing code :)
module TestADCM {
  provides interface StdControl;
  uses {
    interface MSP430ADC12External as ADC12Ext1;
    interface MSP430ADC12External as ADC12Ext2;
    interface MSP430ADC12External as ADC12Ext3;
    interface MSP430ADC12External as ADC12Ext4;
    interface MSP430ADC12External as ADC12Ext5;
    interface MSP430ADC12Internal as ADC12Int1;
    interface MSP430ADC12Advanced as ADC12Adv1;
    interface MSP430ADC12Advanced as ADC12Adv2;
    interface Leds;
    interface RefVolt;
   }
}
implementation {
  int count;
  uint16_t seqdata[10];

  command result_t StdControl.init() { 
    call Leds.init(); 
    return SUCCESS;  
  }
  
  command result_t StdControl.start() {
    //MSP430ADC12StandardSettings_t settings = {sref:1, inch: 2, sht:15}; // Lightsensor  
   call RefVolt.acquire(REFERENCE_2_5V);  // continue at RefVolt.stateChanged
   return SUCCESS;
 }
   
 event void RefVolt.stateChanged(RefVolt_t vref){
   MSP430ADC12StandardSettings_t settings = {
             externalChannel: 2,
             referenceVoltage: REFERENCE_VREFplus_AVss, 
             sampleHoldTime: SAMPLE_HOLD_64_CYCLES
             };
             
   MSP430ADC12AdvancedSettings_t advSettings = {
             externalChannel: 2,
             referenceVoltage: REFERENCE_VREFplus_AVss, 
             sampleHoldTime: SAMPLE_HOLD_64_CYCLES,
             clockSource: CLOCK_SOURCE_SMCLK,
             clockDiv: CLOCK_DIV_1,
             sampleHoldSource: HOLDSOURCE_TIMERB_OUT0
             }; 
                         
   call ADC12Ext1.bind(settings);
   call ADC12Adv1.bind(advSettings);
   call ADC12Adv1.getSequenceData(seqdata, 10, 10);
   call ADC12Ext1.getSingleData(); // trigger conversion, fails
                                                   
    
    //call ADC12Ext1.bind(settings); 
    
    
    //call ADC12Ext2.bind(settings);
    //call ADC12Ext3.bind(settings);
    //call ADC12Ext2.getSingleData();
    //call ADC12Ext1.getSingleData();
    //call ADC12Ext2.stop();
    
    //call ADC12Adv1.getSequenceData(seqdata, 10, 10);
    
    //call ADC12Adv2.bind(advSettings);
    //call ADC12Adv1.getSingleDataRepeat(3214);//(seqdata, 10, 3277);
    //call ADC12Adv1.getSequenceDataRepeat(seqdata, 10, 3277);
    //call ADC12Ext1.getSingleData();
    
    //call ADC12Int1.getData(EXTERNAL_REFERENCE);
    
    return; 
  }
  
  command result_t StdControl.stop() { return SUCCESS; }
 
  /////////////////////////////////////////////////////
  
  int buf[50];
  int count = 0;
  async event void ADC12Adv1.dataReadySingleRpt(uint16_t data){
  }
    
  event void ADC12Adv1.dataReadySequence(){
    call Leds.greenToggle();
    call ADC12Ext1.getSingleData(); 
  }

  async event void ADC12Adv1.dataReadySequenceRpt(){
    call Leds.yellowToggle();
  }
  ////////////////////////////
  
  async event void ADC12Adv2.dataReadySingleRpt(uint16_t data){
    call Leds.redToggle();
  }
    
  event void ADC12Adv2.dataReadySequence(){
    call ADC12Adv1.getSingleDataRepeat(3214);
  }

  async event void ADC12Adv2.dataReadySequenceRpt(){
    call Leds.yellowToggle();
  }
   
  ///////////////////////////////////////////////////////
   
  event void ADC12Ext1.dataReadySingle(uint16_t data){
    call Leds.yellowToggle();
    call ADC12Int1.getData(EXTERNAL_REFERENCE);
 }
  
  async event void ADC12Ext1.dataReadySingleRpt(uint16_t data){
    call Leds.redOn();
  }
  
  event void ADC12Ext1.dataReadySequence(){
    if (count++ >15)
      call ADC12Ext1.getSequenceDataRepeat(seqdata,10);
    else
      call ADC12Ext1.getSequenceData(seqdata,10);
  }
  
  async event void ADC12Ext1.dataReadySequenceRpt(){
    if (count++ > 20){
      call ADC12Ext1.stop();
      call ADC12Ext1.getSingleData();
      call ADC12Ext2.getSingleData(); 
    }
  }
  
  
  //////////////////////////////////////////////////////////////
  
  event void ADC12Ext2.dataReadySingle(uint16_t data){
  }
  
  async event void ADC12Ext2.dataReadySingleRpt(uint16_t data){
      count++;
      if (count == 4){
        call ADC12Ext1.getSingleData();
        call ADC12Ext2.getSingleData();
      }
      if (count == 5)
        call ADC12Ext2.stop();
  }
  async event void ADC12Ext2.dataReadySequenceRpt(){
    seqdata[0] = 1234;
    seqdata[9] = 5678;    
  }
  
  event void ADC12Ext2.dataReadySequence(){}
  event void ADC12Int1.dataReady(MSP430ADC12InternalChannel_t channel, uint16_t data){
    call Leds.redOn();
    return;
    
    count++;
    switch(count){
      case(1): call ADC12Int1.getData(EXTERNAL_REFERENCE); break;
      case(2): call ADC12Int1.getData(REFERENCE_VOLTAGE_RATIO);break;
      case(3): call ADC12Int1.getData(BATTERY_LEVEL);break;
      case(4): call ADC12Ext1.getSingleData();
               call ADC12Ext2.getSingleData(); break;
    }
    call Leds.redToggle();
  }

  event void       ADC12Ext3.dataReadySingle(uint16_t data){
    call ADC12Adv1.getSequenceData(seqdata, 10, 3277);
  }
  
  async event void ADC12Ext3.dataReadySingleRpt(uint16_t data){
  }
  
  async event void ADC12Ext3.dataReadySequenceRpt(){
    if (count++ > 20){
    call ADC12Ext3.getSingleData();
    call ADC12Ext2.getSingleData();
    call ADC12Ext1.getSingleData();
    call ADC12Ext3.stop();
    call ADC12Ext3.getSequenceData(seqdata, 10);
    }
    }
  event void       ADC12Ext3.dataReadySequence(){}

  event void       ADC12Ext4.dataReadySingle(uint16_t data){}
  async event void ADC12Ext4.dataReadySingleRpt(uint16_t data){}
  async event void ADC12Ext4.dataReadySequenceRpt(){} 
  event void       ADC12Ext4.dataReadySequence(){}

  event void       ADC12Ext5.dataReadySingle(uint16_t data){}
  async event void ADC12Ext5.dataReadySingleRpt(uint16_t data){}
  async event void ADC12Ext5.dataReadySequenceRpt(){} 
  event void       ADC12Ext5.dataReadySequence(){}
  
  
}

