/*
 * Copyright (c) 2004, Technische Universitaet Berlin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright 
 *   notice, this list of conditions and the following disclaimer in the 
 *   documentation and/or other materials provided with the distribution.
 * - Neither the name of the Technische Universitaet Berlin nor the names 
 *   of its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * - Revision -------------------------------------------------------------
 * $Revision$
 * $Date$
 * @author: Kevin Klues (klues@tkn.tu-berlin.de)
 * ========================================================================
 */

module RSSIFixedThresholdCMM {
	provides {
		interface StdControl;
		interface ChannelMonitor;
		command result_t setRSSIThreshold(uint16_t level);
	}
	uses {
		interface MSP430ADC12External as ADC12Ext;
	}
}
implementation
{
	#define RSSI_INIT_THRESHOLD     0x450
	  
	norace uint16_t rssiValue;
	norace uint16_t rssiThreshold;
	norace channel_status_t rssiChannelStatus;
	
	command result_t StdControl.init() {
		rssiValue = 0;
		rssiThreshold = RSSI_INIT_THRESHOLD;
		rssiChannelStatus = CHANNEL_BUSY;
		return SUCCESS;
	}
	
	command result_t StdControl.start() {
		//MSP430ADC12StandardSettings_t settings = {sref:1, inch: 3, sht:15};
		MSP430ADC12StandardSettings_t settings = {
             		externalChannel: TOS_ADC_RSSI_PORT,
             		referenceVoltage: REFERENCE_AVcc_AVss, 
             		sampleHoldTime: SAMPLE_HOLD_64_CYCLES
             };
		call ADC12Ext.bind(settings);
	
		return SUCCESS;
	}
	
	command result_t StdControl.stop() {
		return SUCCESS;
	}
	  
	task void ReadRSSI() {
		call ADC12Ext.getSingleData();
	}
	  
	command result_t setRSSIThreshold(uint16_t level) {
		rssiThreshold = level;
	}
	    
	command result_t ChannelMonitor.queryChannel() {
		post ReadRSSI();
		return SUCCESS;
	}
	
	event void ADC12Ext.dataReadySingle(uint16_t data) {
		rssiValue = data;
		if(rssiValue > rssiThreshold) rssiChannelStatus = CHANNEL_BUSY;
		else rssiChannelStatus = CHANNEL_FREE;
		signal ChannelMonitor.queryChannelComplete(rssiChannelStatus);
	}	
	
	async event void ADC12Ext.dataReadySingleRpt(uint16_t data) {}
	event void ADC12Ext.dataReadySequence() {}
	async event void ADC12Ext.dataReadySequenceRpt() {}
}
