/*
 * Copyright (c) 2004, Technische Universitaet Berlin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright 
 *   notice, this list of conditions and the following disclaimer in the 
 *   documentation and/or other materials provided with the distribution.
 * - Neither the name of the Technische Universitaet Berlin nor the names 
 *   of its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * - Description ---------------------------------------------------------
 * Controlling the TDA5250.
 * - Revision -------------------------------------------------------------
 * $Revision$
 * $Date$
 * @author: Jan Hauer (hauer@tkn.tu-berlin.de)
 * ========================================================================
 */
 
includes TDA5250Const;

interface TDA5250Control {
   
   /* all values to default */
   command void reset();
      
   /**
      Set the mode of the radio 
      The choices are SLAVE_MODE, TIMER_MODE, SELF_POLLING_MODE
   */
   command result_t SetMode(TDA5250Mode_t mode);
   command result_t SetSlaveMode();   
   command result_t SetTimerMode(float on_time, float off_time);
   command result_t SetSelfPollingMode(float on_time, float off_time);
   
   /**
      Set the on time and off time of the radio
      (Only makes sense when in TIMER or SELF_POLLING Mode)
   */
   command result_t SetOnTime_ms(float time);
   command result_t SetOffTime_ms(float time);
   
   /**
      Set the frequency that the radio operates at
      (Available frequencies given in TDA5250ClockFreq_t struct)
   */
   command result_t SetOutputFrequency(TDA5250ClockOutFreq_t freq);
   

   /**
      Switches radio between modes when in SLAVE_MODE
   */
   command void TxMode();
   command void RxMode();
   command void SleepMode();
   
   /**
      Sets the RSSI threshold Value for internal evaluation
   */
   command result_t SetRSSIThreshold(uint8_t value);
   command uint8_t GetRSSIValue();
   
   /** 
      Signaled when valid data is detected on the line from the radio
      (Only running when in SELF_POLLING mode)
   */
   async event uint16_t ValidDataDetected();
   
   /**
      Signals that the system is finished changing states
   */
   async event result_t SystemSetupDone();
   async event result_t RadioSetupDone();
   async event result_t ReceiverSetupDone();
   async event result_t DataDetectionSetupDone();
   async event result_t RSSIStableDone();
   async event result_t DataValidDone();
   async event result_t ClockOutSetupDone();
   async event result_t TransmitterSetupDone();
   async event result_t XTALStartupDone();   
}

