/*
 * Copyright (c) 2004, Technische Universitaet Berlin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright 
 *   notice, this list of conditions and the following disclaimer in the 
 *   documentation and/or other materials provided with the distribution.
 * - Neither the name of the Technische Universitaet Berlin nor the names 
 *   of its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * - Description ---------------------------------------------------------
 * Radio configuration.
 * - Revision -------------------------------------------------------------
 * $Revision$
 * $Date$
 * @author: Jan Hauer (hauer@tkn.tu-berlin.de)
 * ========================================================================
 */

configuration TDA5250RadioC {
   provides {
      interface StdControl;
      interface RadioControl;
      interface BareSendMsg as Send;
      interface ReceiveMsg as Receive;
   }
}
implementation
{
   components TDA5250RadioM, TDA5250ControlM, HPLUSART0M, TimerC, 
               RSSIFixedThresholdCMC as CSMA, RandomLFSR, HPLUARTC;
   
   StdControl = TDA5250RadioM;
   StdControl = TimerC;
   StdControl = CSMA;
   StdControl = TDA5250ControlM;
   RadioControl = TDA5250RadioM;
   Receive = TDA5250RadioM;
   Send = TDA5250RadioM;
   
   TDA5250RadioM.HPLUART -> HPLUARTC;
   TDA5250RadioM.TDA5250Control -> TDA5250ControlM;
   TDA5250RadioM.USARTControl -> HPLUSART0M;
   TDA5250RadioM.USARTData -> HPLUSART0M;
   TDA5250RadioM.LocalTime -> TimerC;   
   TDA5250RadioM.AckTimeout -> TimerC.TimerJiffy[unique("TimerJiffy")];
   TDA5250RadioM.BackOffTimer -> TimerC.TimerJiffy[unique("TimerJiffy")];
   TDA5250RadioM.CSMA -> CSMA;
   TDA5250RadioM.Random -> RandomLFSR;
   
   TDA5250ControlM.USART -> HPLUSART0M;
   TDA5250ControlM.DelayTimer -> TimerC.TimerJiffy[unique("TimerJiffy")];
}
