/*
 *
 * $Id$
 *
 */


#ifndef TOSH_HARDWARE_EYESNEDAP
#define TOSH_HARDWARE_EYESNEDAP

#include "msp430hardware.h"
#include "MSP430ADC12.h"

/*
volatile uint16_t PDMode_bits = LPM0_bits;

inline void TOSH_sleep() {
__asm__ __volatile__( "bis	%0, r2" : : "m" ((uint16_t)PDMode_bits) );
}

*/

// LED assignments
TOSH_ASSIGN_PIN(RED_LED, 2, 4);
TOSH_ASSIGN_PIN(GREEN_LED, 2, 5);
TOSH_ASSIGN_PIN(YELLOW_LED, 2, 5);

// USART assignments
TOSH_ASSIGN_PIN(UTXD0, 3, 4);
TOSH_ASSIGN_PIN(URXD0, 3, 5);
TOSH_ASSIGN_PIN(RS232_ENABLE, 2, 3);
TOSH_ASSIGN_PIN(RS232_FORCEON, 5, 0);
TOSH_ASSIGN_PIN(RS232_FORCEOFF, 5, 5);

// Sensor assignments
TOSH_ASSIGN_PIN(RSSI, 6, 0);


void TOSH_SET_PIN_DIRECTIONS(void)
{
  TOSH_MAKE_RED_LED_OUTPUT();
  TOSH_MAKE_GREEN_LED_OUTPUT();
  TOSH_MAKE_YELLOW_LED_OUTPUT();
  
  TOSH_SET_RED_LED_PIN();
  TOSH_SET_GREEN_LED_PIN();

  TOSH_MAKE_RS232_ENABLE_OUTPUT();
  TOSH_SET_RS232_ENABLE_PIN();

  TOSH_MAKE_RS232_FORCEON_OUTPUT();
  TOSH_MAKE_RS232_FORCEOFF_OUTPUT();
  TOSH_SET_RS232_FORCEOFF_PIN();

  TOSH_SEL_RSSI_MODFUNC();
  TOSH_MAKE_RSSI_INPUT();

}

enum
{
  TOSH_ACTUAL_ADC_RSSI_PORT = REFERENCE_VREFplus_AVss,          // Vref_high=Vref+
  TOSH_ACTUAL_ADC_INTERNAL_TEMP_PORT = REFERENCE_VREFplus_AVss, // Vref_high=Vref+
  TOSH_ACTUAL_ADC_BANDGAP_PORT= REFERENCE_VREFplus_AVss         // Vref_high=Vref+

};

enum
{
  TOS_ADC_RSSI_PORT = 0,                     // RSSI on port 3 and Vref_high=Vref+
  TOS_ADC_EXTERNAL_REFERENCE_PORT = 8,       // VeREF+ (input channel 8)
  TOS_ADC_REFERENCE_VOLTAGE_RATIO_PORT = 9,  // VREF-/VeREF- (input channel 9)
  TOS_ADC_INTERNAL_TEMP_PORT = 10,           // Temperature diode (input channel 10)
  TOS_ADC_BATTERY_LEVEL_PORT = 11            // (AVcc-AVss)/2 (input channel 11-15)
};
#endif //TOSH_HARDWARE_H




