#include "appclients.h"
#include "connectionmanager.h"
#include "softwaregatewayclients.h"



AppClient::AppClient(){}


AppClient::~AppClient(){

}

bool AppClient::recieveMsg(){
	return recieveSize(TOS_SIM_PACKET_LENGTH);
}

void AppClient::performService(ConnectionManager* conn){

	if (!recieveMsg())
		return;

	HexUtil::printHexString("From Application",buffer,RADIO_PACKET_LENGTH);


	SoftwareGatewayCommandClient* node = conn->getSoftwareGatewayCommandClient();

	if (node != 0){
		node->sendMsg(buffer,node->UART_COMMAND);
	}

}


AsciiHexAppClient::AsciiHexAppClient() : AppClient(){}


AsciiHexAppClient::~AsciiHexAppClient(){
	close(fd);
}

bool AsciiHexAppClient::recieveMsg(){
	return hexUtil.recieveMsg(this,buffer);
}


void AsciiHexAppClient::send(unsigned char *buffer, int length){
	unsigned char* output = hexUtil.binToHexAscii(buffer,length);

        ClientSocket::send(output,length);
}

