#ifndef APP_CLIENTS_H
#define APP_CLIENTS_H

#include "clientsocket.h"
#include "hexutil.h"

class AppClient : public ClientSocket {

public:
	AppClient();
	~AppClient();

	virtual const char* getName(){return "App client";}
	virtual void performService(ConnectionManager* conn);
private:
	virtual bool recieveMsg();

};


class AsciiHexAppClient : public AppClient {

public:
	AsciiHexAppClient();
	~AsciiHexAppClient();
	virtual const char* getName(){return "ASCII-hex App client";}
	virtual void send(unsigned char *data, int length);

private:
	virtual bool recieveMsg();
	HexUtil hexUtil;

};
















#endif

