#include "broadcastsocket.h"

#include <string.h>
#include <unistd.h>
#include <netdb.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>


#include "nodeclient.h"
#include "exception.h"

extern bool isServer;

BroadcastSocket::BroadcastSocket(){
	sequenceNumber = 0;
	retransmit = true;
}


BroadcastSocket::~BroadcastSocket(){
	
}


void BroadcastSocket::performService(ConnectionManager* conn){

	this->recieve((unsigned char*)&discPacket,sizeof(discPacket));


	if (isServer){
		return;
	}


	if (retransmit && sequenceNumber < ntohl(discPacket.sequenceNumber)){
		sequenceNumber = ntohl(discPacket.sequenceNumber);
		send((unsigned char*)&discPacket,sizeof(discPacket));
	}

	if (conn->getNodeClient() != 0)
		return;


	ClientSocket* node = new NodeClient();
	sequenceNumber = 0;

	try {
		node->connect(discPacket.addr,NODE_SERVER_PORT);
		conn->addIOStream(node);

	}catch(Exception* e){
		printf("Recieved discovery packet from node server and tried to connect:\n");
		e->printErrorMsg();
		delete e;
		delete node;
	}


}





void BroadcastSocket::run(){

	while (!quit){

		try {
			discPacket.sequenceNumber = htonl(++sequenceNumber);
			send((unsigned char*)&discPacket,sizeof(discPacket));
			sleep(DISCOVERY_SEND_INTERVAL);
		} catch (Exception* e){
			e->printErrorMsg();
			return;
		}


	}


}



bool BroadcastSocket::init(const char* localAddr, short port){



	if (isServer){

		if (inet_aton(localAddr,&discPacket.addr) <= 0){
			throw new Exception(this,"Bad address format");
			return false;
		}
	}



	if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) <= 0) {
		throw new Exception(this);
		return false;
	}



	int one = 1;
	setsockopt(fd, SOL_SOCKET, SO_BROADCAST,(char *) &one, sizeof(one));

	sin_len = sizeof(clientSockAddr);



	sendSockAddr.sin_family = AF_INET;
	inet_aton("255.255.255.255",&sendSockAddr.sin_addr);
	sendSockAddr.sin_port = htons(port);

	serverSockAddr.sin_family = AF_INET;
	serverSockAddr.sin_addr.s_addr = INADDR_ANY;
	serverSockAddr.sin_port = htons(port);

	if ( bind( fd, (struct sockaddr *) &serverSockAddr, sizeof serverSockAddr ) < 0 ) {
		throw new Exception(this);
		return false;
	}


	return true;

}


void BroadcastSocket::recieve(unsigned char *buffer, int bufferSize){
	if ((recieved = recvfrom(fd, buffer, bufferSize, 0,(sockaddr *)&clientSockAddr,&sin_len)) <= 0)
		throw new Exception(this);
}


void BroadcastSocket::send(unsigned char *data, int length){

	if ((sent = sendto(fd,data,length,0,(sockaddr*)&sendSockAddr, sizeof(sendSockAddr))) <= 0)
		throw new Exception(this);

}




