#ifndef _BROADCAST_SOCKET_H
#define _BROADCAST_SOCKET_H

#include <arpa/inet.h>

#include "iostream.h"
#include "thread.h"
#include "constants.h"
#include "connectionmanager.h"


#define HOST_NAME_SIZE 32

#pragma pack(1)

struct DiscoveryPacket {
	struct in_addr addr;
	unsigned int sequenceNumber;
	char hostName[HOST_NAME_SIZE];
};

#pragma pack()



class BroadcastSocket : public ioStream, public Thread {
public:
	BroadcastSocket();
	virtual ~BroadcastSocket();
	bool init(const char* localAddr, short port);

	virtual void recieve(unsigned char *buffer, int bufferSize);
	virtual void send(unsigned char *data, int length);
	virtual void performService(ConnectionManager* conn);
	virtual const char* getName(){return "Broadcast";}

	virtual void run();

protected:
	bool retransmit;
	sockaddr_in clientSockAddr;
	sockaddr_in serverSockAddr;
	sockaddr_in sendSockAddr;
	unsigned int sequenceNumber;
	DiscoveryPacket discPacket;
	socklen_t sin_len;




};

#endif
