#include "clientsocket.h"

#include <arpa/inet.h>
#include <stdio.h>
#include <sys/socket.h>
#include <string.h>
#include <errno.h>



#include "exception.h"
#include "constants.h"
#include "hexutil.h"


ClientSocket::ClientSocket(){
	pos = 0;
}


ClientSocket::~ClientSocket(){
	close(fd);
}

void ClientSocket::setFileDescriptor(int fd){
	this->fd = fd;
}


bool ClientSocket::connect(char* addr, short port, bool reconnect){
	in_addr localHost;
	if (inet_aton(addr,&localHost) <= 0){
		throw new Exception(this,"Bad address format");
		return false;
	}
	return connect(localHost,port, reconnect);
}

bool ClientSocket::connect(in_addr addr, short port, bool attempReconnect){
	this->attemptReconnect = attempReconnect;


	bzero(&dest, sizeof(dest));

	dest.sin_family = AF_INET;
	dest.sin_port = htons(port);

	memcpy(&dest.sin_addr.s_addr, &addr, sizeof(addr));
	return reconnect();

}

bool ClientSocket::reconnect(){
	fd = socket(AF_INET,SOCK_STREAM,0);

	if (fd == SOCKET_ERROR){
		throw new Exception(this);
		return false;
	}


	while (::connect(fd, (sockaddr*)&dest, sizeof(dest)) == SOCKET_ERROR) {
		if (!attemptReconnect){
			throw new Exception(this);
			return false;
		}

		printErrorMsg();
		printf("Retry in %i seconds\n",RECONNECT_INTERVAL);
		sleep(RECONNECT_INTERVAL);
	}

	return true;
}


bool ClientSocket::recieveSize(int size){
	recieve(&buffer[pos],size-pos);

	pos += recieved;

	if (pos < size){
		return false;
	}

	pos = 0;

	return true;

}



void ClientSocket::recieve(unsigned char *buffer, int bufferSize){
	if ((recieved = ::recv(fd,buffer,bufferSize,0)) <= 0)
		throw new Exception(this);
}


void ClientSocket::send(unsigned char *data, int length){
	if ((sent = ::send(fd, data, length,0)) <= 0)
		throw new Exception(this);
}

