#ifndef _CLIENTSOCKET_H
#define _CLIENTSOCKET_H

#include <arpa/inet.h>
#include <unistd.h>

#include "iostream.h"
#include "constants.h"


#define SOCKET_ERROR     -1

class ConnectionManager;

class ClientSocket : public ioStream {

public:

	ClientSocket();
	~ClientSocket();

	bool connect(in_addr addr, short port, bool reconnect = false);
	bool connect(char* addr, short port, bool reconnect = false);
	bool reconnect();

	bool recieveSize(int size);
	virtual void recieve(unsigned char *buffer, int bufferSize);
	virtual void send(unsigned char *data, int length);

	virtual void performService(ConnectionManager* conn) = 0;
	virtual const char* getName() = 0;

	void setFileDescriptor(int fd);


protected:
	unsigned char buffer[BUFFER_SIZE];
	int pos;

private:
	sockaddr_in dest;

};



#endif


