#include "connectionmanager.h"

#include <stdio.h>
#include "nodeclient.h"
#include "serialclients.h"
#include "exception.h"




ConnectionManager::ConnectionManager(){
	connections = 0;
	nodeClientIterator = 0;
	serialClientIterator = 0;
	softwareGatewayCommandClientIterator = 0;
	badConnections = false;


}

ConnectionManager::~ConnectionManager(){
	for (int i = 0; i < connections; i++)
		delete deviceList[i];
}

void ConnectionManager::addIOStream(ioStream* stream){

	if (connections < MAX_CONNECTIONS){
		list[connections].fd = stream->fd;
		list[connections].events = POLLIN | POLLERR | POLLHUP;
		list[connections].revents = 0;
		deviceList[connections] = stream;
		connections++;
	}
	else {
		printf("Error: Cannot add iostream, max number of connections %i\n",MAX_CONNECTIONS);
	}
}

void ConnectionManager::stop(){
	quit = true;

}

void ConnectionManager::start(){

	quit = false;
	int numOfReads;

	while (!quit) {


		numOfReads = poll(list,connections,POLL_INTERVAL);

		for (int i = 0; i < connections; i++){

			if (list[i].revents & POLLIN) {
				try {
					deviceList[i]->performService(this);
				} catch (Exception* e){
					submitBadConnection(e->getIOStream());
					delete e;
				}

			}

			if ((list[i].revents & POLLERR) || (list[i].revents & POLLHUP)){
				submitBadConnection(deviceList[i]);
			}
		}
		if (badConnections)
			handleBadConnections();


	}

}


void ConnectionManager::submitBadConnection(ioStream* stream){

	stream->printErrorMsg();
	stream->bad = true;
	badConnections = true;
}

void ConnectionManager::handleBadConnections(){


	for (int i = 0; i < connections; i++){
		if (deviceList[i]->bad){
			if (deviceList[i]->attemptReconnect){
				ClientSocket* client = dynamic_cast<ClientSocket*>(deviceList[i]);
				if (client != 0){
					client->reconnect();
					list[i].fd = client->fd;
					client->bad = false;
				}
			}
			else {
				delete deviceList[i];
				connections--;
				deviceList[i] = deviceList[connections];
				list[i] = list[connections];
				if (i >= 0 && i < connections - 1) i--;
			}

		}

	}

	badConnections = false;



}

ClientSocket* ConnectionManager::getNodeClient(){


	if (NodeClient* node = dynamic_cast<NodeClient*>(deviceList[nodeClientIterator]))
		return node;


	for ( nodeClientIterator = 0; nodeClientIterator < connections; nodeClientIterator++){
		if (NodeClient* node = dynamic_cast<NodeClient*>(deviceList[nodeClientIterator]))
			return node;
	}


	nodeClientIterator = 0;
	return 0;

}



ClientSocket* ConnectionManager::getSerialClient(){


	if (SerialClient* node = dynamic_cast<SerialClient*>(deviceList[serialClientIterator]))
		return node;


	for (serialClientIterator = 0; serialClientIterator < connections; serialClientIterator++){
		if (SerialClient* node = dynamic_cast<SerialClient*>(deviceList[serialClientIterator]))
			return node;
	}


	serialClientIterator = 0;
	return 0;

}

SoftwareGatewayCommandClient* ConnectionManager::getSoftwareGatewayCommandClient(){


	if (SoftwareGatewayCommandClient* node = dynamic_cast<SoftwareGatewayCommandClient*>(deviceList[softwareGatewayCommandClientIterator]))
		return node;


	for (softwareGatewayCommandClientIterator = 0; softwareGatewayCommandClientIterator < connections; softwareGatewayCommandClientIterator++){
		if (SoftwareGatewayCommandClient* node = dynamic_cast<SoftwareGatewayCommandClient*>(deviceList[softwareGatewayCommandClientIterator]))
			return node;
	}


	softwareGatewayCommandClientIterator = 0;
	return 0;

}





