#ifndef _CONNECTIONMANAGER_H
#define _CONNECTIONMANAGER_H

#include <sys/time.h>
#include <sys/types.h>
#include <sys/poll.h>
#include <errno.h>
#include <unistd.h>

#include "softwaregatewayclients.h"


class ConnectionManager {

public:
	ConnectionManager();
	~ConnectionManager();
	void start();
	void addIOStream(ioStream* stream);
	void stop();

	ClientSocket* getNodeClient();
	ClientSocket* getSerialClient();
	SoftwareGatewayCommandClient* getSoftwareGatewayCommandClient();

	int connections;
	ioStream* deviceList[MAX_CONNECTIONS];


private:
	pollfd list[MAX_CONNECTIONS];
	bool badConnections;
	bool quit;
	int nodeClientIterator;
	int serialClientIterator;
	int softwareGatewayCommandClientIterator;
	void handleBadConnections();
	//ioStream* getIOStream(int& iterator, ioStream::Types type);

	void submitBadConnection(ioStream* iostream);

};

#endif

